/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetails;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.jbpm.console.ng.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskDetailsViewImpl.html")
public class TaskDetailsViewImpl
extends Composite
implements TaskDetailsPresenter.TaskDetailsView {
    private TaskDetailsPresenter presenter;
    @Inject
    @DataField
    public TextBox userText;
    @Inject
    @DataField
    public TextBox taskStatusText;
    @Inject
    @DataField
    public TextArea taskDescriptionTextArea;
    @Inject
    @DataField
    public Select taskPriorityListBox;
    @Inject
    @DataField
    public UTCDateBox dueDate;
    @Inject
    @DataField
    public UTCTimeBox dueDateTime;
    @Inject
    @DataField
    public Button updateTaskButton;
    @Inject
    @DataField
    public FormLabel taskStatusLabel;
    @Inject
    @DataField
    public FormLabel userLabel;
    @Inject
    @DataField
    public FormLabel dueDateLabel;
    @Inject
    @DataField
    public FormLabel taskPriorityLabel;
    @Inject
    @DataField
    public FormLabel taskDescriptionLabel;
    @Inject
    private PlaceManager placeManager;
    private String[] priorities = new String[]{"0 - High", "1", "2", "3", "4", "5 - Medium", "6", "7", "8", "9", "10 - Low"};
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    @Override
    public void init(TaskDetailsPresenter presenter) {
        this.presenter = presenter;
        for (int i = 0; i < this.priorities.length; ++i) {
            Option option = new Option();
            option.setText(this.priorities[i]);
            option.setValue(String.valueOf(i));
            this.taskPriorityListBox.add((Widget)option);
        }
        this.taskPriorityListBox.refresh();
        this.taskStatusLabel.setText(this.constants.Status());
        this.userLabel.setText(this.constants.User());
        this.dueDateLabel.setText(this.constants.Due_On());
        this.taskPriorityLabel.setText(this.constants.Priority());
        this.taskDescriptionLabel.setText(this.constants.Description());
        this.updateTaskButton.setText(this.constants.Update());
        this.dueDate.getDateBox().setContainer((Widget)this);
    }

    @EventHandler(value={"updateTaskButton"})
    public void updateTaskButton(ClickEvent e) {
        this.presenter.updateTask(this.taskDescriptionTextArea.getText(), this.userText.getText(), this.dueDate.getValue() != null && this.dueDateTime.getValue() != null ? UTCDateBox.utc2date((Long)(this.dueDate.getValue() + this.dueDateTime.getValue())) : null, Integer.valueOf(this.taskPriorityListBox.getValue()));
    }

    @Override
    public TextBox getUserText() {
        return this.userText;
    }

    @Override
    public TextArea getTaskDescriptionTextArea() {
        return this.taskDescriptionTextArea;
    }

    @Override
    public Select getTaskPriorityListBox() {
        return this.taskPriorityListBox;
    }

    @Override
    public UTCDateBox getDueDate() {
        return this.dueDate;
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public String[] getPriorities() {
        return this.priorities;
    }

    @Override
    public TextBox getTaskStatusText() {
        return this.taskStatusText;
    }

    @Override
    public UTCTimeBox getDueDateTime() {
        return this.dueDateTime;
    }

    @Override
    public Button getUpdateTaskButton() {
        return this.updateTaskButton;
    }
}

