/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.tasklogs;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskAuditService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.paging.PageResponse;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskLogsPresenterTest {
    private static final Long TASK_ID = 1L;
    @Mock
    private TaskAuditService taskAuditServiceMock;
    private Caller<TaskAuditService> taskAuditService;
    @Mock
    private TaskLogsPresenter.TaskLogsView taskLogsView;
    private TaskLogsPresenter presenter;

    @Before
    public void setupMocks() {
        this.taskAuditService = new CallerMock((Object)this.taskAuditServiceMock);
        this.presenter = new TaskLogsPresenter(this.taskLogsView, this.taskAuditService);
        Mockito.when((Object)this.taskAuditServiceMock.getData((QueryFilter)Matchers.any(QueryFilter.class))).thenReturn(Mockito.mock(PageResponse.class));
    }

    @Test
    public void logsUpdatedWhenTaskSelected() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        ((TaskAuditService)Mockito.verify((Object)this.taskAuditServiceMock)).getData((QueryFilter)Matchers.any(QueryFilter.class));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogTextAreaText("");
    }

    @Test
    public void logsUpdatedWhenTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID.longValue()));
        ((TaskAuditService)Mockito.verify((Object)this.taskAuditServiceMock, (VerificationMode)Mockito.times((int)2))).getData((QueryFilter)Matchers.any(QueryFilter.class));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)2))).setLogTextAreaText("");
    }

    @Test
    public void logsNotUpdatedWhenDifferentTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID + 1L));
        ((TaskAuditService)Mockito.verify((Object)this.taskAuditServiceMock)).getData((QueryFilter)Matchers.any(QueryFilter.class));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogTextAreaText("");
    }
}

