/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.tasklogs;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskAuditService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.paging.PageResponse;

@Dependent
public class TaskLogsPresenter {
    private TaskLogsView view;
    private Caller<TaskAuditService> taskAuditService;
    private long currentTaskId = 0L;
    private Constants constants = Constants.INSTANCE;

    @Inject
    public TaskLogsPresenter(TaskLogsView view, Caller<TaskAuditService> taskAuditService) {
        this.view = view;
        this.taskAuditService = taskAuditService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void refreshLogs() {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("taskId", this.currentTaskId);
        PortableQueryFilter filter = new PortableQueryFilter(0, 0, false, "", "", false, "", params);
        ((TaskAuditService)this.taskAuditService.call((RemoteCallback)new RemoteCallback<PageResponse<TaskEventSummary>>(){

            public void callback(PageResponse<TaskEventSummary> events) {
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                for (TaskEventSummary tes : events.getPageRowList()) {
                    String timeStamp = DateUtils.getDateTimeStr((Date)tes.getLogTime());
                    if (tes.getType().equals("UPDATED")) {
                        safeHtmlBuilder.appendEscapedLines(timeStamp + ": Task " + tes.getType() + " (" + tes.getMessage() + ") \n");
                        continue;
                    }
                    safeHtmlBuilder.appendEscapedLines(timeStamp + ": Task - " + tes.getType() + " (" + tes.getUserId() + ") \n");
                }
                TaskLogsPresenter.this.view.setLogTextAreaText(safeHtmlBuilder.toSafeHtml().asString());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskLogsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getData((QueryFilter)filter);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshLogs();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshLogs();
        }
    }

    public static interface TaskLogsView
    extends IsWidget {
        public void init(TaskLogsPresenter var1);

        public void displayNotification(String var1);

        public void setLogTextAreaText(String var1);
    }
}

