/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.util.TaskUtils;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.paging.PageResponse;

@Dependent
@WorkbenchScreen(identifier="Tasks List")
public class TasksListGridPresenter
extends AbstractScreenListPresenter<TaskSummary> {
    public static String FILTER_STATUSES_PARAM_NAME = "statuses";
    public static String FILTER_CURRENT_ROLE_PARAM_NAME = "filter";
    @Inject
    private TaskListView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Caller<TaskQueryService> taskQueryService;
    @Inject
    private Caller<TaskLifeCycleService> taskOperationsService;
    private String currentRole;
    private List<String> currentStatuses;
    private TaskUtils.TaskType currentStatusFilter = TaskUtils.TaskType.ACTIVE;

    public TasksListGridPresenter() {
        this.dataProvider = new AsyncDataProvider<TaskSummary>(){

            protected void onRangeChanged(HasData<TaskSummary> display) {
                TasksListGridPresenter.this.view.showBusyIndicator(TasksListGridPresenter.this.constants.Loading());
                Range visibleRange = TasksListGridPresenter.this.view.getListGrid().getVisibleRange();
                TasksListGridPresenter.this.getData(visibleRange);
            }
        };
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (!this.isAddingDefaultFilters()) {
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (this.currentFilter == null) {
                this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
            }
            if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
                this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
                this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
                this.currentFilter.setFilterParams("");
            } else {
                this.currentFilter.setFilterParams("(LOWER(t.name) like '" + this.currentFilter.getParams().get("textSearch") + "' or LOWER(t.description) like '" + this.currentFilter.getParams().get("textSearch") + "') ");
                this.currentFilter.setOffset(Integer.valueOf(0));
                this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
            }
            if (this.currentStatusFilter == null) {
                this.currentFilter.getParams().put("statuses", TaskUtils.getStatusByType((TaskUtils.TaskType)this.currentStatusFilter));
            } else {
                this.currentFilter.getParams().put("statuses", this.currentStatuses);
            }
            this.currentFilter.getParams().put("filter", this.currentStatusFilter.toString());
            this.currentFilter.getParams().put("userId", this.identity.getIdentifier());
            this.currentFilter.getParams().put("taskRole", this.currentRole);
            this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
            this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
            ((TaskQueryService)this.taskQueryService.call((RemoteCallback)new RemoteCallback<PageResponse<TaskSummary>>(){

                public void callback(PageResponse<TaskSummary> response) {
                    TasksListGridPresenter.this.updateDataOnCallback(response);
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    TasksListGridPresenter.this.view.hideBusyIndicator();
                    TasksListGridPresenter.this.view.displayNotification("Error: Getting Tasks: " + throwable.toString());
                    GWT.log((String)message.toString());
                    return true;
                }
            })).getData(this.currentFilter);
        }
    }

    public void filterGrid(String currentRole, List<String> currentStatuses) {
        this.currentRole = currentRole;
        this.currentStatuses = currentStatuses;
        this.refreshGrid();
    }

    public void refreshActiveTasks() {
        this.currentRole = "Potential Owner";
        this.currentStatusFilter = TaskUtils.TaskType.ACTIVE;
        this.refreshGrid();
    }

    public void refreshPersonalTasks() {
        this.currentRole = "Potential Owner";
        this.currentStatusFilter = TaskUtils.TaskType.PERSONAL;
        this.refreshGrid();
    }

    public void refreshGroupTasks() {
        this.currentRole = "Potential Owner";
        this.currentStatusFilter = TaskUtils.TaskType.GROUP;
        this.refreshGrid();
    }

    public void refreshAllTasks() {
        this.currentRole = "Potential Owner";
        this.currentStatusFilter = TaskUtils.TaskType.ALL;
        this.refreshGrid();
    }

    public void refreshAdminTasks() {
        this.currentRole = "Administrator";
        this.currentStatusFilter = TaskUtils.TaskType.ADMIN;
        this.refreshGrid();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List();
    }

    @WorkbenchPartView
    public UberView<TasksListGridPresenter> getView() {
        return this.view;
    }

    public void releaseTask(Long taskId, String userId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                TasksListGridPresenter.this.view.displayNotification("Task Released");
                TasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                TasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).release(taskId.longValue(), userId);
    }

    public void claimTask(Long taskId, String userId, String deploymentId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                TasksListGridPresenter.this.view.displayNotification("Task Claimed");
                TasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                TasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).claim(taskId.longValue(), userId, deploymentId);
    }

    public static interface TaskListView
    extends AbstractListView.ListView<TaskSummary, TasksListGridPresenter> {
    }
}

