/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskcomments;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskCommentsViewImpl.html")
public class TaskCommentsViewImpl
extends Composite
implements TaskCommentsPresenter.TaskCommentsView {
    protected static final String COL_ADDEDBY = "addedBy";
    protected static final String COL_ADDEDAT = "addedAt";
    protected static final String COL_COMMENT = "comment";
    protected static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = (Constants)GWT.create(Constants.class);
    private TaskCommentsPresenter presenter;
    @Inject
    @DataField
    public TextArea newTaskCommentTextArea;
    @Inject
    @DataField
    public FormLabel newTaskCommentLabel = (FormLabel)GWT.create(FormLabel.class);
    @Inject
    @DataField
    public Button addCommentButton = (Button)GWT.create(Button.class);
    @DataField
    public PagedTable<CommentSummary> commentsListGrid = new PagedTable(10);
    @Inject
    private Event<NotificationEvent> notification;
    private ColumnSortEvent.ListHandler<CommentSummary> sortHandler;
    private static final int COMMENTS_PER_PAGE = 10;

    @Override
    public void clearCommentInput() {
        this.newTaskCommentTextArea.setText("");
    }

    @Override
    public void redrawDataGrid() {
        this.commentsListGrid.refresh();
        this.commentsListGrid.redraw();
    }

    public void init(TaskCommentsPresenter presenter) {
        this.presenter = presenter;
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_COMMENT);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ADDEDBY);
        initColumns.add(COL_COMMENT);
        initColumns.add(COL_ADDEDAT);
        initColumns.add(COL_ID_ACTIONS);
        this.commentsListGrid.setGridPreferencesStore(new GridPreferencesStore(new GridGlobalPreferences("CommentsGrid", initColumns, bannedColumns)));
        this.commentsListGrid.setEmptyTableCaption(this.constants.No_Comments_For_This_Task());
        this.sortHandler = new ColumnSortEvent.ListHandler(presenter.getDataProvider().getList());
        this.commentsListGrid.addColumnSortHandler(this.sortHandler);
        this.initTableColumns();
        presenter.addDataDisplay((HasData<CommentSummary>)this.commentsListGrid);
        this.addCommentButton.setText(this.constants.Add_Comment());
        this.newTaskCommentLabel.setText(this.constants.Comment());
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(ClickEvent e) {
        this.presenter.addTaskComment(this.newTaskCommentTextArea.getText());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void initTableColumns() {
        Column<CommentSummary, String> addedByColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                int first = c.getAddedBy().indexOf(39);
                int last = c.getAddedBy().lastIndexOf(39);
                return c.getAddedBy().substring(first + 1, last);
            }
        };
        addedByColumn.setSortable(false);
        addedByColumn.setDataStoreName(COL_ADDEDBY);
        this.commentsListGrid.addColumn((Column)addedByColumn, this.constants.Added_By());
        this.commentsListGrid.setColumnWidth((Column)addedByColumn, 100.0, Style.Unit.PX);
        Column<CommentSummary, String> addedAtColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                return DateUtils.getDateTimeStr((Date)c.getAddedAt());
            }
        };
        addedAtColumn.setSortable(true);
        addedAtColumn.setDataStoreName(COL_ADDEDAT);
        addedAtColumn.setDefaultSortAscending(true);
        this.commentsListGrid.addColumn((Column)addedAtColumn, this.constants.At());
        this.sortHandler.setComparator((Column)addedAtColumn, (Comparator)new Comparator<CommentSummary>(){

            @Override
            public int compare(CommentSummary o1, CommentSummary o2) {
                return o1.getAddedAt().compareTo(o2.getAddedAt());
            }
        });
        Column<CommentSummary, String> commentTextColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary object) {
                return object.getText();
            }
        };
        commentTextColumn.setSortable(false);
        commentTextColumn.setDataStoreName(COL_COMMENT);
        this.commentsListGrid.addColumn((Column)commentTextColumn, this.constants.Comment());
        LinkedList<DeleteCommentActionHasCell> cells = new LinkedList<DeleteCommentActionHasCell>();
        cells.add(new DeleteCommentActionHasCell(this.constants.Delete(), new ActionCell.Delegate<CommentSummary>(){

            public void execute(CommentSummary comment) {
                TaskCommentsViewImpl.this.presenter.removeTaskComment(comment.getId());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<CommentSummary, CommentSummary> actionsColumn = new Column<CommentSummary, CommentSummary>((Cell)cell){

            public CommentSummary getValue(CommentSummary object) {
                return object;
            }
        };
        actionsColumn.setSortable(false);
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        this.commentsListGrid.addColumn((Column)actionsColumn, "");
    }

    private class DeleteCommentActionHasCell
    implements HasCell<CommentSummary, CommentSummary> {
        private ActionCell<CommentSummary> cell;

        public DeleteCommentActionHasCell(String text, ActionCell.Delegate<CommentSummary> delegate) {
            this.cell = new ActionCell<CommentSummary>(text, delegate){

                public void render(Cell.Context context, CommentSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant(new SimplePanel((Widget)new Button(TaskCommentsViewImpl.this.constants.Delete()){
                        {
                            this.setSize(ButtonSize.SMALL);
                            this.setType(ButtonType.DANGER);
                        }
                    }).getElement().getInnerHTML());
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<CommentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<CommentSummary, CommentSummary> getFieldUpdater() {
            return null;
        }

        public CommentSummary getValue(CommentSummary object) {
            return object;
        }
    }
}

