/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskassignments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.client.editors.taskassignments.TaskAssignmentsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAssignmentsPresenterTest {
    private static final String CURRENT_USER = "Jan";
    private static final String OTHER_USER = "OTHER_USER";
    @Mock
    private TaskAssignmentsPresenter.TaskAssignmentsView viewMock;
    @Mock
    private User userMock;
    @Mock
    private TaskLifeCycleService lifecycleServiceMock;
    private Caller<TaskLifeCycleService> lifecycleServiceCallerMock;
    @Mock
    private TaskOperationsService operationsServiceMock;
    private Caller<TaskOperationsService> operationsServiceCallerMock;
    private TaskAssignmentsPresenter presenter;

    @Before
    public void initMocks() {
        Mockito.when((Object)this.userMock.getIdentifier()).thenReturn((Object)CURRENT_USER);
        this.lifecycleServiceCallerMock = new CallerMock((Object)this.lifecycleServiceMock);
        this.operationsServiceCallerMock = new CallerMock((Object)this.operationsServiceMock);
        Event taskRefreshed = (Event)Mockito.spy((Object)new EventSourceMock());
        ((Event)Mockito.doNothing().when((Object)taskRefreshed)).fire(Mockito.any(TaskRefreshedEvent.class));
        this.presenter = new TaskAssignmentsPresenter(this.viewMock, this.userMock, this.lifecycleServiceCallerMock, this.operationsServiceCallerMock, taskRefreshed);
    }

    @Test
    public void delegationButtonDisabled_whenDelegationSuccessful() {
        long TASK_ID = 1L;
        Mockito.when((Object)this.operationsServiceMock.getTaskDetails(1L)).thenReturn((Object)new TaskSummary(1L, null, null, "Completed", 0, CURRENT_USER, null, null, null, null, null, 0L, 0L, null, 0L));
        Mockito.when((Object)this.operationsServiceMock.allowDelegate(Mockito.eq((long)1L), (String)Mockito.eq((Object)CURRENT_USER), Mockito.anySet())).thenReturn((Object)true);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(1L)));
        this.presenter.delegateTask(OTHER_USER);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setDelegateButtonActive(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
    }

    @Test
    public void emptyDelegationUserOrGroup_notAccepted() {
        this.presenter.delegateTask("");
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setHelpText(Constants.INSTANCE.DelegationUserInputRequired());
        ((TaskLifeCycleService)Mockito.verify((Object)this.lifecycleServiceMock, (VerificationMode)Mockito.never())).delegate(Matchers.anyLong(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void nullDelegationUserOrGroup_notAccepted() {
        this.presenter.delegateTask(null);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setHelpText(Constants.INSTANCE.DelegationUserInputRequired());
        ((TaskLifeCycleService)Mockito.verify((Object)this.lifecycleServiceMock, (VerificationMode)Mockito.never())).delegate(Matchers.anyLong(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void delegationDisabled_whenCompletedTaskSelected() {
        long COMPLETED_TASK_ID = 1L;
        Mockito.when((Object)this.operationsServiceMock.getTaskDetails(1L)).thenReturn((Object)new TaskSummary(1L, null, null, "Completed", 0, CURRENT_USER, null, null, null, null, null, 0L, 0L, null, 0L));
        Mockito.when((Object)this.operationsServiceMock.allowDelegate(Mockito.eq((long)1L), (String)Mockito.eq((Object)CURRENT_USER), Mockito.anySet())).thenReturn((Object)false);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(1L)));
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableUserOrGroupInput(true);
    }

    @Test
    public void delegationDisabled_whenTaskNotOwnedByCurrentUserSelected() {
        long TASK_OWNED_BY_SOMEONE_ELSE_ID = 2L;
        Mockito.when((Object)this.operationsServiceMock.getTaskDetails(2L)).thenReturn((Object)new TaskSummary(2L, null, null, "Ready", 0, OTHER_USER, null, null, null, null, null, 0L, 0L, null, 0L));
        Mockito.when((Object)this.operationsServiceMock.allowDelegate(Mockito.eq((long)2L), (String)Mockito.eq((Object)OTHER_USER), Mockito.anySet())).thenReturn((Object)false);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(2L)));
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableUserOrGroupInput(true);
    }

    @Test
    public void delegationEnabled_whenTaskOwnedByCurrentUserSelected() {
        long TASK_OWNED_BY_CURRENT_USER = 3L;
        Mockito.when((Object)this.operationsServiceMock.getTaskDetails(3L)).thenReturn((Object)new TaskSummary(3L, null, null, "Ready", 0, CURRENT_USER, null, null, null, null, null, 0L, 0L, null, 0L));
        Mockito.when((Object)this.operationsServiceMock.allowDelegate(Mockito.eq((long)3L), (String)Mockito.eq((Object)CURRENT_USER), Mockito.anySet())).thenReturn((Object)true);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(3L)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewMock});
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupInput(true);
    }
}

