/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.gc.client.util.TaskUtils;
import org.jbpm.console.ng.ht.client.editors.quicknewtask.QuickNewTaskPopup;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.TasksListGridPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.NewTaskEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class TasksListGridViewImpl
extends AbstractMultiGridView<TaskSummary, TasksListGridPresenter>
implements TasksListGridPresenter.TaskListView {
    private final Constants constants = (Constants)GWT.create(Constants.class);
    public static final String COL_ID_ID = "t.id";
    public static final String COL_ID_NAME = "t.name";
    public static final String COL_ID_DESCRIPTION = "t.description";
    public static final String COL_ID_PRIORITY = "t.priority";
    public static final String COL_ID_STATUS = "t.taskData.status";
    public static final String COL_ID_CREATEON = "t.taskData.createdOn";
    public static final String COL_ID_EXPIRATIONTIME = "t.taskData.expirationTime";
    public static final String COL_ID_ACTIONS = "Actions";
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    @Inject
    private QuickNewTaskPopup quickNewTaskPopup;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;

    public void init(final TasksListGridPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_NAME);
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_NAME);
        initColumns.add(COL_ID_DESCRIPTION);
        initColumns.add(COL_ID_ACTIONS);
        final Button button = new Button();
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Command addNewGrid = new Command(){

                    public void execute() {
                        HashMap newTabFormValues = TasksListGridViewImpl.this.newTabFilterPopup.getFormValues();
                        List selectedCurrentRole = (List)newTabFormValues.get(TasksListGridPresenter.FILTER_CURRENT_ROLE_PARAM_NAME);
                        String currentRole = null;
                        if (selectedCurrentRole != null && selectedCurrentRole.size() > 0) {
                            currentRole = (String)selectedCurrentRole.get(0);
                        }
                        newTabFormValues.put(TasksListGridPresenter.FILTER_CURRENT_ROLE_PARAM_NAME, currentRole);
                        final String key = TasksListGridViewImpl.this.getValidKeyForAdditionalListGrid("TaskListGrid_");
                        TasksListGridViewImpl.this.filterPagedTable.saveNewTabSettings(key, newTabFormValues);
                        final ExtendedPagedTable extendedPagedTable = TasksListGridViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        TasksListGridViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                TasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                                TasksListGridViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        TasksListGridViewImpl.this.applyFilterOnPresenter(newTabFormValues);
                    }
                };
                TasksListGridViewImpl.this.createFilterForm();
                TasksListGridViewImpl.this.newTabFilterPopup.show(addNewGrid, TasksListGridViewImpl.this.getMultiGridPreferencesStore());
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("TaskListGrid", initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        this.selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == TasksListGridViewImpl.this.selectedRow) {
                    return "selected";
                }
                if (row.getStatus().equals("InProgress") || row.getStatus().equals("Ready")) {
                    if (row.getPriority() == 5) {
                        return "five";
                    }
                    if (row.getPriority() == 4) {
                        return "four";
                    }
                    if (row.getPriority() == 3) {
                        return "three";
                    }
                    if (row.getPriority() == 2) {
                        return "two";
                    }
                    if (row.getPriority() == 1) {
                        return "one";
                    }
                } else if (row.getStatus().equals("Completed")) {
                    return "completed";
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (TasksListGridViewImpl.this.selectedRow == -1) {
                    TasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.setRowStyles(TasksListGridViewImpl.this.selectedStyles);
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != TasksListGridViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(TasksListGridViewImpl.this.selectedStyles);
                    TasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                TasksListGridViewImpl.this.selectedItem = (GenericSummary)TasksListGridViewImpl.this.selectionModel.getLastSelectedObject();
                DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("Task Details Multi");
                PlaceStatus status = TasksListGridViewImpl.this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
                boolean logOnly = false;
                if (((TaskSummary)TasksListGridViewImpl.this.selectedItem).getStatus().equals("Completed") && ((TaskSummary)TasksListGridViewImpl.this.selectedItem).isLogOnly()) {
                    logOnly = true;
                }
                if (status == PlaceStatus.CLOSE) {
                    TasksListGridViewImpl.this.placeManager.goTo((PlaceRequest)defaultPlaceRequest);
                    TasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)TasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)TasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)TasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && !close) {
                    TasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)TasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)TasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)TasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && close) {
                    TasksListGridViewImpl.this.placeManager.closePlace("Task Details Multi");
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<TaskSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<TaskSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<TaskSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.getColumnIndex(TasksListGridViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initExtraButtons(ExtendedPagedTable extendedPagedTable) {
        Button newTaskButton = new Button();
        newTaskButton.setTitle(this.constants.New_Task());
        newTaskButton.setIcon(IconType.PLUS);
        newTaskButton.setTitle(Constants.INSTANCE.New_Task());
        newTaskButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TasksListGridViewImpl.this.quickNewTaskPopup.show();
            }
        });
        extendedPagedTable.getRightActionsToolbar().clear();
        extendedPagedTable.getRightActionsToolbar().add((Widget)newTaskButton);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column taskIdColumn = this.initTaskIdColumn();
        Column taskNameColumn = this.initTaskNameColumn();
        Column descriptionColumn = this.initTaskDescriptionColumn();
        Column taskPriorityColumn = this.initTaskPriorityColumn();
        Column statusColumn = this.initTaskStatusColumn();
        Column createdOnDateColumn = this.initTaskCreatedOnColumn();
        Column dueDateColumn = this.initTaskDueColumn();
        this.actionsColumn = this.initActionsColumn(extendedPagedTable);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(taskIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(taskNameColumn, this.constants.Task()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Description()));
        columnMetas.add(new ColumnMeta(taskPriorityColumn, this.constants.Priority()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(createdOnDateColumn, "CreatedOn"));
        columnMetas.add(new ColumnMeta(dueDateColumn, "DueOn"));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private void createFilterForm() {
        HashMap<String, String> stateListBoxInfo = new HashMap<String, String>();
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_CREATED, Constants.INSTANCE.Created());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_READY, Constants.INSTANCE.Ready());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_RESERVED, Constants.INSTANCE.Reserved());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_INPROGRESS, Constants.INSTANCE.InProgress());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_SUSPENDED, Constants.INSTANCE.Suspended());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_FAILED, Constants.INSTANCE.Failed());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_ERROR, Constants.INSTANCE.Error());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_EXITED, Constants.INSTANCE.Exited());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_OBSOLETE, Constants.INSTANCE.Obsolete());
        stateListBoxInfo.put(TaskUtils.TASK_STATUS_COMPLETED, Constants.INSTANCE.Completed());
        HashMap<String, String> currentRoleListBoxInfo = new HashMap<String, String>();
        currentRoleListBoxInfo.put("Initiator", Constants.INSTANCE.Initiator());
        currentRoleListBoxInfo.put("Stakeholder", Constants.INSTANCE.Stakeholder());
        currentRoleListBoxInfo.put("Potential Owner", Constants.INSTANCE.Potential_Owner());
        currentRoleListBoxInfo.put("Actual Owner", Constants.INSTANCE.Actual_Owner());
        currentRoleListBoxInfo.put("Administrator", Constants.INSTANCE.Administrator());
        this.newTabFilterPopup.init();
        this.newTabFilterPopup.addListBoxToFilter(Constants.INSTANCE.Status(), TasksListGridPresenter.FILTER_STATUSES_PARAM_NAME, true, stateListBoxInfo);
        this.newTabFilterPopup.addListBoxToFilter(Constants.INSTANCE.TaskRole(), TasksListGridPresenter.FILTER_CURRENT_ROLE_PARAM_NAME, false, currentRoleListBoxInfo);
    }

    private void initCellPreview(final ExtendedPagedTable extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    TasksListGridViewImpl.this.onMouseOverGrid(extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column initTaskIdColumn() {
        Column<TaskSummary, Number> taskIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getTaskId();
            }
        };
        taskIdColumn.setSortable(true);
        taskIdColumn.setDataStoreName(COL_ID_ID);
        return taskIdColumn;
    }

    private Column initTaskNameColumn() {
        Column<TaskSummary, String> taskNameColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getTaskName();
            }
        };
        taskNameColumn.setSortable(true);
        taskNameColumn.setDataStoreName(COL_ID_NAME);
        return taskNameColumn;
    }

    private Column initTaskDescriptionColumn() {
        Column<TaskSummary, String> descriptionColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName(COL_ID_DESCRIPTION);
        return descriptionColumn;
    }

    private Column initTaskPriorityColumn() {
        Column<TaskSummary, Number> taskPriorityColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getPriority();
            }
        };
        taskPriorityColumn.setSortable(true);
        taskPriorityColumn.setDataStoreName(COL_ID_PRIORITY);
        return taskPriorityColumn;
    }

    private Column initTaskStatusColumn() {
        Column<TaskSummary, String> statusColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName(COL_ID_STATUS);
        return statusColumn;
    }

    private Column initTaskCreatedOnColumn() {
        Column<TaskSummary, String> createdOnDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getCreatedOn());
            }
        };
        createdOnDateColumn.setSortable(true);
        createdOnDateColumn.setDataStoreName(COL_ID_CREATEON);
        return createdOnDateColumn;
    }

    private Column initTaskDueColumn() {
        Column<TaskSummary, String> dueDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getExpirationTime());
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName(COL_ID_EXPIRATIONTIME);
        return dueDateColumn;
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        ((TasksListGridPresenter)this.presenter).refreshGrid();
    }

    private Column initActionsColumn(final ExtendedPagedTable extendedPagedTable) {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ClaimActionHasCell(this.constants.Claim(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((TasksListGridPresenter)TasksListGridViewImpl.this.presenter).claimTask(task.getTaskId(), TasksListGridViewImpl.this.identity.getIdentifier(), task.getDeploymentId());
                TasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new ReleaseActionHasCell(this.constants.Release(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((TasksListGridPresenter)TasksListGridViewImpl.this.presenter).releaseTask(task.getTaskId(), TasksListGridViewImpl.this.identity.getIdentifier());
                TasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new CompleteActionHasCell(this.constants.Complete(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                TasksListGridViewImpl.this.placeManager.goTo("Task Details Multi");
                boolean logOnly = false;
                if (task.getStatus().equals("Completed") && task.isLogOnly()) {
                    logOnly = true;
                }
                TasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getName(), task.isForAdmin(), logOnly));
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void refreshNewTask(@Observes NewTaskEvent newTask) {
        ((TasksListGridPresenter)this.presenter).refreshGrid();
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Task Details Multi"));
        if (status == PlaceStatus.OPEN) {
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        } else {
            this.placeManager.goTo("Task Details Multi");
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        }
        this.selectionModel.setSelected((Object)new TaskSummary(newTask.getNewTaskId(), newTask.getNewTaskName()), true);
    }

    private PlaceStatus getPlaceStatus(String place) {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest(place);
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
        return status;
    }

    private void closePlace(String place) {
        if (this.getPlaceStatus(place) == PlaceStatus.OPEN) {
            this.placeManager.closePlace(place);
        }
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((TasksListGridPresenter)this.presenter).setAddingDefaultFilters(true);
        List states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE);
        this.initTabFilter(preferences, "TaskListGrid_0", Constants.INSTANCE.Active(), "Filter " + Constants.INSTANCE.Active(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.PERSONAL);
        this.initTabFilter(preferences, "TaskListGrid_1", Constants.INSTANCE.Personal(), "Filter " + Constants.INSTANCE.Personal(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.GROUP);
        this.initTabFilter(preferences, "TaskListGrid_2", Constants.INSTANCE.Group(), "Filter " + Constants.INSTANCE.Group(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        this.initTabFilter(preferences, "TaskListGrid_3", Constants.INSTANCE.All(), "Filter " + Constants.INSTANCE.All(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ADMIN);
        this.initTabFilter(preferences, "TaskListGrid_4", Constants.INSTANCE.Task_Admin(), "Filter " + Constants.INSTANCE.Task_Admin(), states, "Administrator");
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries("TaskListGrid_0");
    }

    private void initTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        HashMap<String, Object> tabSettingsValues = new HashMap<String, Object>();
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tabName);
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tabDesc);
        tabSettingsValues.put(TasksListGridPresenter.FILTER_STATUSES_PARAM_NAME, states);
        tabSettingsValues.put(TasksListGridPresenter.FILTER_CURRENT_ROLE_PARAM_NAME, role);
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((TasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                TasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                TasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        List states = (List)params.get(TasksListGridPresenter.FILTER_STATUSES_PARAM_NAME);
        String currentRole = (String)params.get(TasksListGridPresenter.FILTER_CURRENT_ROLE_PARAM_NAME);
        ((TasksListGridPresenter)this.presenter).filterGrid(currentRole, states);
    }

    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    protected class ReleaseActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ReleaseActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getActualOwner().equals(TasksListGridViewImpl.this.identity.getIdentifier()) && (value.getStatus().equals("Reserved") || value.getStatus().equals("InProgress"))) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class ClaimActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ClaimActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getStatus().equals("Ready")) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class CompleteActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public CompleteActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getStatus().equals("InProgress")) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

