/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskcomments;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskCommentsService;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@Dependent
public class TaskCommentsPresenter {
    private Constants constants = Constants.INSTANCE;
    private final TaskCommentsView view;
    private final Caller<TaskCommentsService> taskCommentsServices;
    private final User identity;
    private final ListDataProvider<CommentSummary> dataProvider = new ListDataProvider();
    private long currentTaskId = 0L;

    @Inject
    public TaskCommentsPresenter(TaskCommentsView view, Caller<TaskCommentsService> taskCommentsServices, User identity) {
        this.view = view;
        this.taskCommentsServices = taskCommentsServices;
        this.identity = identity;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public ListDataProvider<CommentSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshComments() {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<List<CommentSummary>>(){

            public void callback(List<CommentSummary> comments) {
                TaskCommentsPresenter.this.dataProvider.getList().clear();
                TaskCommentsPresenter.this.dataProvider.getList().addAll(comments);
                TaskCommentsPresenter.this.view.redrawDataGrid();
            }
        }, (ErrorCallback)new DefaultErrorCallback())).getAllCommentsByTaskId(this.currentTaskId);
    }

    public void addTaskComment(String text) {
        if ("".equals(text.trim())) {
            this.view.displayNotification(this.constants.CommentCannotBeEmpty());
        } else {
            this.addTaskComment(text, new Date());
        }
    }

    private void addTaskComment(String text, Date addedOn) {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
            }
        }, (ErrorCallback)new DefaultErrorCallback())).addComment(this.currentTaskId, text, this.identity.getIdentifier(), addedOn);
    }

    public void removeTaskComment(long commentId) {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
                TaskCommentsPresenter.this.view.displayNotification(TaskCommentsPresenter.this.constants.CommentDeleted());
            }
        }, (ErrorCallback)new DefaultErrorCallback())).deleteComment(this.currentTaskId, commentId);
    }

    public void addDataDisplay(HasData<CommentSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshComments();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshComments();
        }
    }

    public static interface TaskCommentsView
    extends UberView<TaskCommentsPresenter> {
        public void clearCommentInput();

        public void redrawDataGrid();

        public void displayNotification(String var1);
    }
}

