/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetailsmulti;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.console.ng.ht.client.editors.taskassignments.TaskAssignmentsPresenter;
import org.jbpm.console.ng.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.console.ng.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.console.ng.ht.client.editors.taskform.TaskFormPresenter;
import org.jbpm.console.ng.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.console.ng.ht.client.editors.taskprocesscontext.TaskProcessContextPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.forms.client.display.ht.api.HumanTaskFormDisplayProvider;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskDisplayerConfig;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Task Details Multi", preferredWidth=655)
public class TaskDetailsMultiPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    private TaskDetailsMultiView view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private HumanTaskFormDisplayProvider taskFormDisplayProvider;
    @Inject
    private TaskFormPresenter taskFormPresenter;
    @Inject
    private TaskDetailsPresenter taskDetailsPresenter;
    @Inject
    private TaskLogsPresenter taskLogsPresenter;
    @Inject
    private TaskAssignmentsPresenter taskAssignmentsPresenter;
    @Inject
    private TaskCommentsPresenter taskCommentsPresenter;
    @Inject
    private TaskAdminPresenter taskAdminPresenter;
    @Inject
    private TaskProcessContextPresenter taskProcessContextPresenter;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    private PlaceRequest place;
    private String taskId = "";
    private String taskName = "";
    private boolean forLog = false;
    private boolean forAdmin = false;

    @WorkbenchPartView
    public UberView<TaskDetailsMultiPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public boolean isForAdmin() {
        return this.forAdmin;
    }

    public void setIsForAdmin(boolean isForAdmin) {
        this.forAdmin = isForAdmin;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.taskId = String.valueOf(event.getTaskId());
        this.taskName = event.getTaskName();
        this.taskFormPresenter.getTaskFormView().getDisplayerView().setOnCloseCommand(new Command(){

            public void execute() {
                TaskDetailsMultiPresenter.this.closeDetails();
            }
        });
        this.taskFormDisplayProvider.setup(new HumanTaskDisplayerConfig(new TaskKey(event.getTaskId())), this.taskFormPresenter.getTaskFormView().getDisplayerView());
        this.setIsForLog(event.isForLog());
        this.setIsForAdmin(event.isForAdmin());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.taskId) + " - " + this.taskName));
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
            this.disableTaskDetailsEdition();
        } else {
            this.view.displayAllTabs();
        }
        if (this.isForAdmin()) {
            this.view.setAdminTabVisible(true);
        } else {
            this.view.setAdminTabVisible(false);
        }
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void onRefresh() {
        this.taskSelected.fire((Object)new TaskSelectionEvent(Long.valueOf(this.taskId), this.taskName, this.isForAdmin(), this.isForLog()));
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public IsWidget getGenericFormView() {
        return this.taskFormPresenter.getView();
    }

    public IsWidget getTaskDetailsView() {
        return this.taskDetailsPresenter.getView();
    }

    public IsWidget getProcessContextView() {
        return this.taskProcessContextPresenter.getView();
    }

    public IsWidget getTaskAssignmentsView() {
        return this.taskAssignmentsPresenter.getView();
    }

    public IsWidget getTaskCommentsView() {
        return this.taskCommentsPresenter.getView();
    }

    public IsWidget getTaskAdminView() {
        return this.taskAdminPresenter.getView();
    }

    public IsWidget getTaskLogsView() {
        return this.taskLogsPresenter.getView();
    }

    public void taskDetailsRefresh() {
        this.taskDetailsPresenter.refreshTask();
    }

    public void disableTaskDetailsEdition() {
        this.taskDetailsPresenter.setReadOnlyTaskDetail();
    }

    public void taskProcessContextRefresh() {
        this.taskProcessContextPresenter.refreshProcessContextOfTask();
    }

    public void taskAssignmentsRefresh() {
        this.taskAssignmentsPresenter.refreshTaskPotentialOwners();
    }

    public void taskCommentsRefresh() {
        this.taskCommentsPresenter.refreshComments();
    }

    public void taskLogsRefresh() {
        this.taskLogsPresenter.refreshLogs();
    }

    public void taskAdminRefresh() {
        this.taskAdminPresenter.refreshTaskPotentialOwners();
    }

    public static interface TaskDetailsMultiView
    extends UberView<TaskDetailsMultiPresenter> {
        public void setAdminTabVisible(boolean var1);

        public void displayAllTabs();

        public void displayOnlyLogTab();
    }
}

