/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.backend.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.console.ng.ht.forms.service.PlaceManagerActivityService;
import org.jbpm.console.ng.ht.model.events.RenderFormEvent;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;

@ApplicationScoped
public class PlaceManagerFormProvider
implements FormProvider {
    @Inject
    private Event<RenderFormEvent> renderForm;
    private List<String> allActivities;
    @Inject
    private PlaceManagerActivityService pmas;

    @PostConstruct
    public void init() {
        this.allActivities = this.pmas.getAllActivities();
    }

    public int getPriority() {
        return 0;
    }

    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        HashMap<String, Object> params = new HashMap<String, Object>(renderContext.size());
        for (String key : renderContext.keySet()) {
            if (renderContext.get(key) instanceof Task || key.equals("marshallerContext")) continue;
            params.put(key, renderContext.get(key));
        }
        if (process != null) {
            params.put("processId", process.getId());
            if (this.allActivities.contains(process.getId() + " Form")) {
                this.renderForm.fire((Object)new RenderFormEvent(process.getId() + " Form", params));
                return "handledByPlaceManagerFormProvider";
            }
        }
        return "";
    }

    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        HashMap<String, Object> params = new HashMap<String, Object>(renderContext.size());
        String taskName = renderContext.get("TaskName") != null ? (String)renderContext.get("TaskName") : "";
        for (String key : renderContext.keySet()) {
            if (renderContext.get(key) instanceof Task || key.equals("marshallerContext")) continue;
            params.put(key, renderContext.get(key));
        }
        if (task != null) {
            params.put("taskId", task.getId().toString());
            params.put("taskStatus", task.getTaskData().getStatus().toString());
        }
        if (process != null) {
            params.put("processId", process.getId());
        }
        if (this.allActivities.contains(taskName + " Form")) {
            this.renderForm.fire((Object)new RenderFormEvent(taskName, params));
            return "handledByPlaceManagerFormProvider";
        }
        return "";
    }
}

