/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.backend.server;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.console.ng.ht.forms.service.PlaceManagerActivityService;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;

@ApplicationScoped
public class PlaceManagerFormProvider
implements FormProvider {
    private List<String> allActivities;
    @Inject
    private PlaceManagerActivityService pmas;

    @PostConstruct
    public void init() {
        this.allActivities = this.pmas.getAllActivities();
    }

    public int getPriority() {
        return 0;
    }

    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        HashMap<String, String> params = new HashMap<String, String>(renderContext.size());
        for (String key : renderContext.keySet()) {
            if (renderContext.get(key) instanceof Task || key.equals("marshallerContext")) continue;
            params.put(key, renderContext.get(key).toString());
        }
        if (process != null) {
            params.put("processId", process.getId());
            String destination = process.getId() + " Form";
            if (this.allActivities.contains(destination)) {
                this.assetManagementHack(process, renderContext, params);
                return this.getFormRenderingInfo(destination, params);
            }
        }
        return "";
    }

    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        String destination;
        HashMap<String, String> params = new HashMap<String, String>(renderContext.size());
        String taskName = renderContext.get("TaskName") != null ? (String)renderContext.get("TaskName") : "";
        for (String key : renderContext.keySet()) {
            if (renderContext.get(key) instanceof Task || key.equals("marshallerContext")) continue;
            String paramValue = renderContext.get(key) != null ? renderContext.get(key).toString() : null;
            params.put(key, paramValue);
        }
        if (task != null) {
            params.put("taskId", task.getId().toString());
            params.put("taskName", task.getName());
            params.put("taskDescription", task.getDescription());
            params.put("taskStatus", task.getTaskData().getStatus().toString());
        }
        if (process != null) {
            params.put("processId", process.getId());
            params.put("processName", process.getName());
        }
        if (this.allActivities.contains(destination = taskName + " Form")) {
            this.assetManagementHack(process, renderContext, params);
            return this.getFormRenderingInfo(destination, params);
        }
        return "";
    }

    protected String getFormRenderingInfo(String destination, Map<String, String> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("handler", "handledByPlaceManagerFormProvider");
        result.put("destination", destination);
        result.put("params", params);
        Gson gson = new Gson();
        return gson.toJson(result);
    }

    protected void assetManagementHack(ProcessDefinition process, Map<String, Object> renderContext, Map<String, String> params) {
        if (process.getId().equals("guvnor-asset-management.PromoteAssets")) {
            Map commitsPerFile = (Map)renderContext.get("in_commits_per_file");
            StringBuffer commits = new StringBuffer();
            for (String file : commitsPerFile.keySet()) {
                if (commits.length() > 0) {
                    commits.append(";");
                }
                commits.append(file).append("=");
                for (String commit : (List)commitsPerFile.get(file)) {
                    if (!commits.substring(commits.length() - 1).equals("=")) {
                        commits.append(",");
                    }
                    commits.append(commit);
                }
            }
            params.put("in_commits_per_file", commits.toString());
        }
    }
}

