/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.admin.client.editors.settings;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.bd.model.ProcessSummary;
import org.jbpm.console.ng.pr.admin.client.i18n.ProcessAdminConstants;
import org.jbpm.console.ng.pr.admin.service.ProcessAdminService;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;

@Dependent
@WorkbenchScreen(identifier="Process Admin Settings")
public class ProcessAdminSettingsPresenter {
    public static final String SCREEN_ID = "Process Admin Settings";
    private final Map<String, ProcessSummary> processeSummaryMap = Maps.newHashMap();
    private ProcessAdminConstants constants = ProcessAdminConstants.INSTANCE;
    @Inject
    private ProcessAdminSettingsView view;
    @Inject
    private Caller<ProcessAdminService> instancesAdminServices;
    @Inject
    private Caller<SpecManagementService> specManagementService;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @PostConstruct
    public void init() {
        ((SpecManagementService)this.specManagementService.call(st -> {
            ImmutableSet stId = FluentIterable.from((Iterable)st).filter(e -> e.getServerInstanceKeys() != null && !e.getServerInstanceKeys().isEmpty()).transform(s -> s.getId()).toSet();
            this.view.addServerTemplates((Set<String>)stId);
        })).listServerTemplates();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Instances_Admin();
    }

    @WorkbenchPartView
    public UberView<ProcessAdminSettingsPresenter> getView() {
        return this.view;
    }

    public void generateMockInstances(String serverTemplateId, String processId, int amountOfTasks) {
        ProcessSummary summary = this.processeSummaryMap.get(processId);
        if (summary == null) {
            return;
        }
        ((ProcessAdminService)this.instancesAdminServices.call(p -> this.view.displayNotification(this.constants.ProcessInstancesSuccessfullyCreated()))).generateMockInstances(serverTemplateId, summary.getDeploymentId(), summary.getProcessDefId(), null, null, Integer.valueOf(amountOfTasks));
    }

    public void onServerTemplateSelected(String serverTemplateId) {
        this.view.clearProcessList();
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(ps -> {
            this.processeSummaryMap.clear();
            ImmutableSet pid = FluentIterable.from((Iterable)ps).transform(p -> {
                this.processeSummaryMap.put(p.getProcessDefId(), (ProcessSummary)p);
                return p.getProcessDefId();
            }).toSet();
            this.view.addProcessList((Set<String>)pid);
        })).getProcesses(serverTemplateId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), "", Boolean.valueOf(true));
    }

    public static interface ProcessAdminSettingsView
    extends UberView<ProcessAdminSettingsPresenter> {
        public void displayNotification(String var1);

        public void addServerTemplates(Set<String> var1);

        public void clearProcessList();

        public void addProcessList(Set<String> var1);
    }
}

