/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.admin.client.editors.settings;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.pr.admin.client.editors.settings.ProcessAdminSettingsPresenter;
import org.jbpm.console.ng.pr.admin.client.i18n.ProcessAdminConstants;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="ProcessAdminSettingsViewImpl.html")
public class ProcessAdminSettingsViewImpl
extends Composite
implements ProcessAdminSettingsPresenter.ProcessAdminSettingsView {
    @Inject
    @DataField
    public Button generateMockInstancesButton;
    @Inject
    @DataField
    public Button resetButton;
    @Inject
    @DataField
    public FormLabel processListLabel;
    @Inject
    @DataField
    public FormLabel amountOfTasksLabel;
    @Inject
    @DataField
    public TextBox amountOfTasksText;
    @Inject
    @DataField
    public Select serverTemplate;
    @Inject
    @DataField
    public FormLabel serverTemplateLabel;
    @Inject
    @DataField
    public Select processList;
    private ProcessAdminSettingsPresenter presenter;
    @Inject
    private Event<NotificationEvent> notification;
    private ProcessAdminConstants constants = ProcessAdminConstants.INSTANCE;

    public void init(ProcessAdminSettingsPresenter presenter) {
        this.presenter = presenter;
        this.serverTemplateLabel.setText(this.constants.ServerTemplate());
        this.serverTemplateLabel.setShowRequiredIndicator(true);
        this.processListLabel.setText(this.constants.ProcessId());
        this.processListLabel.setShowRequiredIndicator(true);
        this.amountOfTasksLabel.setText(this.constants.Amount_Of_Tasks());
        this.amountOfTasksLabel.setShowRequiredIndicator(true);
        this.amountOfTasksText.setText("1");
        this.generateMockInstancesButton.setText(this.constants.Generate_Mock_Instances());
        this.resetButton.setText(this.constants.Reset());
        this.serverTemplate.addValueChangeHandler(e -> presenter.onServerTemplateSelected(this.serverTemplate.getValue()));
    }

    @EventHandler(value={"resetButton"})
    public void resetClick(ClickEvent e) {
        this.serverTemplate.setValue((Object)"");
        this.amountOfTasksText.setText("1");
        this.clearProcessList();
    }

    @EventHandler(value={"generateMockInstancesButton"})
    public void generateMockInstancesButton(ClickEvent e) {
        this.presenter.generateMockInstances(this.serverTemplate.getValue(), this.processList.getValue(), Integer.parseInt(this.amountOfTasksText.getText()));
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void addServerTemplates(Set<String> serverTemplateIds) {
        this.serverTemplate.clear();
        this.serverTemplate.setValue((Object)"");
        for (String serverTemplateId : serverTemplateIds) {
            Option option = new Option();
            option.setText(serverTemplateId);
            option.setValue(serverTemplateId);
            this.serverTemplate.add((Widget)option);
        }
        this.serverTemplate.refresh();
    }

    @Override
    public void clearProcessList() {
        this.processList.clear();
        this.processList.setValue((Object)"");
        this.processList.refresh();
    }

    @Override
    public void addProcessList(Set<String> processIds) {
        this.clearProcessList();
        for (String processId : processIds) {
            Option option = new Option();
            option.setText(processId);
            option.setValue(processId);
            this.processList.add((Widget)option);
        }
        this.processList.refresh();
    }
}

