/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.console.ng.pr.model.ProcessInstanceKey;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.kie.internal.query.QueryContext;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    @Inject
    private RuntimeDataService dataService;

    public PageResponse<ProcessInstanceSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List states = null;
        String initiator = "";
        if (filter.getParams() != null) {
            states = (List)filter.getParams().get("states");
            initiator = (String)filter.getParams().get("initiator");
        }
        QueryFilterImpl qf = new QueryFilterImpl(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        Collection processInstances = this.dataService.getProcessInstances(states, initiator, (QueryContext)qf);
        ArrayList<ProcessInstanceSummary> processInstancesSums = new ArrayList<ProcessInstanceSummary>(processInstances.size());
        for (ProcessInstanceDesc pi : processInstances) {
            if (filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                processInstancesSums.add(ProcessInstanceHelper.adapt(pi));
                continue;
            }
            if (!pi.getProcessName().toLowerCase().contains((String)filter.getParams().get("textSearch"))) continue;
            processInstancesSums.add(ProcessInstanceHelper.adapt(pi));
        }
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(processInstancesSums.size() - 1);
        if (processInstancesSums.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!processInstancesSums.isEmpty() && processInstancesSums.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList(processInstancesSums.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList(processInstancesSums));
            response.setLastPage(true);
        }
        return response;
    }

    public ProcessInstanceSummary getItem(ProcessInstanceKey key) {
        return ProcessInstanceHelper.adapt(this.dataService.getProcessInstanceById(key.getProcessInstanceId().longValue()));
    }
}

