/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.backend.server.ProcessHelper;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.service.ProcessDefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.kie.internal.query.QueryContext;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    @Inject
    private RuntimeDataService dataService;

    public PageResponse<ProcessSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        Collection processDefs = (String)filter.getParams().get("textSearch") != null && !((String)filter.getParams().get("textSearch")).equals("") ? this.dataService.getProcessesByFilter((String)filter.getParams().get("textSearch"), (QueryContext)qf) : this.dataService.getProcesses((QueryContext)qf);
        ArrayList<ProcessSummary> processDefsSums = new ArrayList<ProcessSummary>(ProcessHelper.adaptCollection(processDefs));
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(processDefsSums.size() - 1);
        if (processDefsSums.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        response.setPageRowList(processDefsSums);
        if (!processDefsSums.isEmpty() && processDefsSums.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList(processDefsSums.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<ProcessSummary>(processDefsSums));
            response.setLastPage(true);
        }
        return response;
    }

    public ProcessSummary getItem(ProcessDefinitionKey key) {
        return ProcessHelper.adapt(this.dataService.getProcessesByDeploymentIdProcessId(key.getDeploymentId(), key.getProcessId()));
    }
}

