/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.log;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.model.RuntimeLogSummary;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.pr.client.util.LogUtils;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class RuntimeLogPresenter {
    private String currentProcessInstanceId;
    @Inject
    private RuntimeLogView view;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void refreshProcessInstanceData(final LogUtils.LogOrder logOrder, LogUtils.LogType logType) {
        this.view.getLogTextArea().setHTML("");
        if (LogUtils.LogType.TECHNICAL.equals((Object)logType)) {
            ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<RuntimeLogSummary>>(){

                public void callback(List<RuntimeLogSummary> logs) {
                    SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                    if (logOrder == LogUtils.LogOrder.DESC) {
                        Collections.reverse(logs);
                    }
                    for (RuntimeLogSummary rls : logs) {
                        safeHtmlBuilder.appendEscapedLines(rls.getTime() + ": " + rls.getLogLine() + " - " + rls.getType() + "\n");
                    }
                    RuntimeLogPresenter.this.view.getLogTextArea().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                    return true;
                }
            })).getAllRuntimeLogs(Long.valueOf(this.currentProcessInstanceId).longValue());
        } else {
            ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<RuntimeLogSummary>>(){

                public void callback(List<RuntimeLogSummary> logs) {
                    SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                    if (logOrder == LogUtils.LogOrder.DESC) {
                        Collections.reverse(logs);
                    }
                    for (RuntimeLogSummary rls : logs) {
                        safeHtmlBuilder.appendEscapedLines(rls.getTime() + ": " + rls.getLogLine() + "\n");
                    }
                    RuntimeLogPresenter.this.view.getLogTextArea().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                    return true;
                }
            })).getBusinessLogs(Long.valueOf(this.currentProcessInstanceId).longValue());
        }
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.currentProcessInstanceId = String.valueOf(event.getProcessInstanceId());
        this.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
    }

    public static interface RuntimeLogView
    extends IsWidget {
        public void init(RuntimeLogPresenter var1);

        public void displayNotification(String var1);

        public HTML getLogTextArea();
    }
}

