/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessDefSelectionEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.kie.workbench.common.widgets.client.workbench.configuration.ContextualView;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class ProcessDefinitionListViewImpl
extends AbstractListView<ProcessSummary, ProcessDefinitionListPresenter>
implements ProcessDefinitionListPresenter.ProcessDefinitionListView {
    public static final String COL_ID_PROCESSNAME = "ProcessName";
    public static final String COL_ID_PROCESSVERSION = "ProcessVersion";
    public static final String COL_ID_PROJECT = "Project";
    public static final String COL_ID_ACTIONS = "Actions";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelected;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private ContextualView contextualView;
    private String placeIdentifier;

    public void init(ProcessDefinitionListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_PROCESSNAME);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_PROCESSNAME);
        initColumns.add(COL_ID_PROCESSVERSION);
        initColumns.add(COL_ID_PROJECT);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("ProcessDefinitionsGrid", initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                PlaceStatus status;
                boolean close = false;
                if (ProcessDefinitionListViewImpl.this.selectedRow == -1) {
                    ProcessDefinitionListViewImpl.this.listGrid.setRowStyles(ProcessDefinitionListViewImpl.this.selectedStyles);
                    ProcessDefinitionListViewImpl.this.selectedRow = ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDefinitionListViewImpl.this.listGrid.redraw();
                } else if (ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow() != ProcessDefinitionListViewImpl.this.selectedRow) {
                    ProcessDefinitionListViewImpl.this.listGrid.setRowStyles(ProcessDefinitionListViewImpl.this.selectedStyles);
                    ProcessDefinitionListViewImpl.this.selectedRow = ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDefinitionListViewImpl.this.listGrid.redraw();
                } else {
                    close = true;
                }
                ProcessDefinitionListViewImpl.this.selectedItem = (GenericSummary)ProcessDefinitionListViewImpl.this.selectionModel.getLastSelectedObject();
                PlaceStatus instanceDetailsStatus = ProcessDefinitionListViewImpl.this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
                if (instanceDetailsStatus == PlaceStatus.OPEN) {
                    ProcessDefinitionListViewImpl.this.placeManager.closePlace("Process Instance Details Multi");
                }
                ProcessDefinitionListViewImpl.this.placeIdentifier = "Basic Process Details Multi";
                if (ProcessDefinitionListViewImpl.this.contextualView.getViewMode("all_prespectives").equals("Advanced")) {
                    ProcessDefinitionListViewImpl.this.placeIdentifier = "Advanced Process Details Multi";
                }
                if ((status = ProcessDefinitionListViewImpl.this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest(ProcessDefinitionListViewImpl.this.placeIdentifier))) == PlaceStatus.CLOSE) {
                    ProcessDefinitionListViewImpl.this.placeManager.goTo(ProcessDefinitionListViewImpl.this.placeIdentifier);
                    ProcessDefinitionListViewImpl.this.processDefSelected.fire((Object)new ProcessDefSelectionEvent(((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem).getProcessDefId(), ((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem).getDeploymentId()));
                } else if (status == PlaceStatus.OPEN && !close) {
                    ProcessDefinitionListViewImpl.this.processDefSelected.fire((Object)new ProcessDefSelectionEvent(((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem).getProcessDefId(), ((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem).getDeploymentId()));
                } else if (status == PlaceStatus.OPEN && close) {
                    ProcessDefinitionListViewImpl.this.placeManager.closePlace(ProcessDefinitionListViewImpl.this.placeIdentifier);
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && ProcessDefinitionListViewImpl.this.listGrid.getColumnIndex(ProcessDefinitionListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setEmptyTableCaption(this.constants.No_Process_Definitions_Found());
        this.listGrid.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column processNameColumn = this.initProcessNameColumn();
        Column versionColumn = this.initVersionColumn();
        Column projectColumn = this.initProjectColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(projectColumn, this.constants.Project()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initProcessNameColumn() {
        Column<ProcessSummary, String> processNameColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getProcessDefName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDataStoreName(COL_ID_PROCESSNAME);
        return processNameColumn;
    }

    private Column initVersionColumn() {
        Column<ProcessSummary, String> versionColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName(COL_ID_PROCESSVERSION);
        return versionColumn;
    }

    private Column initProjectColumn() {
        Column<ProcessSummary, String> projectColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getDeploymentId();
            }
        };
        projectColumn.setSortable(true);
        projectColumn.setDataStoreName(COL_ID_PROJECT);
        return projectColumn;
    }

    private Column initActionsColumn() {
        LinkedList<StartActionHasCell> cells = new LinkedList<StartActionHasCell>();
        cells.add(new StartActionHasCell("Start process", new ActionCell.Delegate<ProcessSummary>(){

            public void execute(ProcessSummary process) {
                ((ProcessDefinitionListPresenter)ProcessDefinitionListViewImpl.this.presenter).openGenericForm(process.getProcessDefId(), process.getDeploymentId(), process.getProcessDefName());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessSummary, ProcessSummary> actionsColumn = new Column<ProcessSummary, ProcessSummary>((Cell)cell){

            public ProcessSummary getValue(ProcessSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void refreshNewProcessInstance(@Observes NewProcessInstanceEvent newProcessInstance) {
        PlaceStatus definitionDetailsStatus;
        this.placeIdentifier = "Basic Process Details Multi";
        if (this.contextualView.getViewMode("all_prespectives").equals("Advanced")) {
            this.placeIdentifier = "Advanced Process Details Multi";
        }
        if ((definitionDetailsStatus = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest(this.placeIdentifier))) == PlaceStatus.OPEN) {
            this.placeManager.closePlace(this.placeIdentifier);
        }
        this.placeManager.goTo("Process Instance Details Multi");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getDeploymentId(), newProcessInstance.getNewProcessInstanceId(), newProcessInstance.getNewProcessDefId(), newProcessInstance.getProcessDefName(), newProcessInstance.getNewProcessInstanceStatus()));
    }

    private class StartActionHasCell
    implements HasCell<ProcessSummary, ProcessSummary> {
        private ActionCell<ProcessSummary> cell;

        public StartActionHasCell(String text, ActionCell.Delegate<ProcessSummary> delegate) {
            this.cell = new ActionCell<ProcessSummary>(text, delegate){

                public void render(Cell.Context context, ProcessSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + ProcessDefinitionListViewImpl.this.constants.Start() + "'>" + ProcessDefinitionListViewImpl.this.constants.Start() + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<ProcessSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<ProcessSummary, ProcessSummary> getFieldUpdater() {
            return null;
        }

        public ProcessSummary getValue(ProcessSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, ProcessDefinitionListViewImpl> {
    }
}

