/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.documents.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.DocumentSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.service.DocumentsService;
import org.uberfire.paging.PageResponse;

@Dependent
public class ProcessDocumentListPresenter
extends AbstractListPresenter<DocumentSummary> {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private ProcessDocumentListView view;
    @Inject
    private Caller<DocumentsService> documentsServices;
    private String processInstanceId;
    private String processDefId;
    private String deploymentId;
    private String documentId;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.processInstanceId = String.valueOf(event.getProcessInstanceId());
        this.processDefId = event.getProcessDefId();
        this.deploymentId = event.getDeploymentId();
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (this.processInstanceId != null) {
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (this.currentFilter == null) {
                this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
            }
            if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
                this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
                this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
            } else {
                this.currentFilter.setOffset(Integer.valueOf(0));
                this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
            }
            if (this.currentFilter.getParams() == null) {
                this.currentFilter.setParams(new HashMap());
            }
            this.currentFilter.getParams().put("processInstanceId", this.processInstanceId);
            this.currentFilter.getParams().put("processDefId", this.processDefId);
            this.currentFilter.getParams().put("deploymentId", this.deploymentId);
            this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
            this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
            ((DocumentsService)this.documentsServices.call((RemoteCallback)new RemoteCallback<PageResponse<DocumentSummary>>(){

                public void callback(PageResponse<DocumentSummary> response) {
                    ProcessDocumentListPresenter.this.updateDataOnCallback(response);
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ProcessDocumentListPresenter.this.view.hideBusyIndicator();
                    ProcessDocumentListPresenter.this.view.displayNotification("Error: Getting Process DocumentList: " + message);
                    GWT.log((String)throwable.toString());
                    return true;
                }
            })).getData(this.currentFilter);
        }
    }

    public static interface ProcessDocumentListView
    extends AbstractListView.ListView<DocumentSummary, ProcessDocumentListPresenter> {
        public void init(ProcessDocumentListPresenter var1);
    }
}

