/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.dash;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance List")
public class DataSetProcessInstanceListPresenter
extends AbstractScreenListPresenter<ProcessInstanceSummary> {
    @Inject
    private DataSetProcessInstanceListView view;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                if (currentTableSettings != null) {
                    currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                    ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                    if (columnSortList != null && columnSortList.size() > 0) {
                        this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                        this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                    } else {
                        this.dataSetQueryHelper.setLastOrderedColumn("start_date");
                        this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                    }
                    if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                        DataSetFilter filter = new DataSetFilter();
                        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                        filters.add(FilterFactory.likeTo((String)"processInstanceDescription", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filters.add(FilterFactory.likeTo((String)"processName", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filters.add(FilterFactory.likeTo((String)"processId", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                            currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        } else {
                            currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                        }
                        this.textSearchStr = "";
                    }
                    this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                    this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                        public void callback(DataSet dataSet) {
                            if (dataSet != null) {
                                ArrayList<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
                                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                    myProcessInstancesFromDataSet.add(new ProcessInstanceSummary(DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "externalId", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processName", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processVersion", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnIntValue(dataSet, "status", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "start_date", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "user_identity", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "correlationKey", i), DataSetProcessInstanceListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentProcessInstanceId", i)));
                                }
                                PageResponse processInstanceSummaryPageResponse = new PageResponse();
                                processInstanceSummaryPageResponse.setPageRowList(myProcessInstancesFromDataSet);
                                processInstanceSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                                processInstanceSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                                processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                                if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                    processInstanceSummaryPageResponse.setLastPage(true);
                                } else {
                                    processInstanceSummaryPageResponse.setLastPage(false);
                                }
                                DataSetProcessInstanceListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
                            }
                            DataSetProcessInstanceListPresenter.this.view.hideBusyIndicator();
                        }

                        public void notFound() {
                            DataSetProcessInstanceListPresenter.this.view.hideBusyIndicator();
                            DataSetProcessInstanceListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmProcessInstances ] ");
                            GWT.log((String)"DataSet with UUID [  jbpmProcessInstances ] not found.");
                        }

                        public boolean onError(ClientRuntimeError error) {
                            DataSetProcessInstanceListPresenter.this.view.hideBusyIndicator();
                            DataSetProcessInstanceListPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmProcessInstances ] error: " + error.getThrowable());
                            GWT.log((String)"DataSet with UUID [  jbpmProcessInstances ] error: ", (Throwable)error.getThrowable());
                            return false;
                        }
                    });
                } else {
                    this.view.hideBusyIndicator();
                }
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmProcessInstances ]");
        }
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.refreshGrid();
    }

    public void abortProcessInstance(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstance(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstances(processInstanceIds);
    }

    public void suspendProcessInstance(String processDefId, long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).suspendProcessInstance(processInstanceId);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        StringBuilder processIdsParam = new StringBuilder();
        if (processInstances != null) {
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Signaling_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                processIdsParam.append(selected.getId() + ",");
            }
            if (processIdsParam.length() > 0) {
                processIdsParam.deleteCharAt(processIdsParam.length() - 1);
            }
        } else {
            processIdsParam.append("-1");
        }
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(this.constants.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances != null && Window.confirm((String)"Are you sure that you want to abort the selected process instances?")) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Aborting_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                ids.add(selected.getProcessInstanceId());
                this.view.displayNotification(this.constants.Aborting_Process_Instance() + "(id=" + selected.getId() + ")");
            }
            this.abortProcessInstance(ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Instances();
    }

    @WorkbenchPartView
    public UberView<DataSetProcessInstanceListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        this.view.setupButtons();
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                DataSetProcessInstanceListPresenter.this.newProcessInstancePopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceListPresenter.this.view.getMenuRefreshButton().addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceListPresenter.this.refreshGrid();
                            }
                        });
                        return DataSetProcessInstanceListPresenter.this.view.getMenuRefreshButton();
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DataSetProcessInstanceListPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.DataSetProcessInstanceList#menuActionsButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceListPresenter.this.view.getMenuResetTabsButton().addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceListPresenter.this.view.restoreTabs();
                            }
                        });
                        return DataSetProcessInstanceListPresenter.this.view.getMenuResetTabsButton();
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.DataSetProcessInstanceList#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    protected void saveRefreshValue(int newValue) {
        this.view.saveRefreshValue(newValue);
    }

    protected int getRefreshValue() {
        return this.view.getRefreshValue();
    }

    public static interface DataSetProcessInstanceListView
    extends AbstractListView.ListView<ProcessInstanceSummary, DataSetProcessInstanceListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);
    }
}

