/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash.DataSetProcessInstanceWithVariablesListPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash.ProcessInstancesWithVariableListViewExtension;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetProcessInstanceWithVariablesListViewTest {
    @Mock
    protected ExtendedPagedTable currentListGrid;
    @Mock
    protected GridPreferencesStore gridPreferencesStore;
    @Mock
    protected DataSetEditorManager dataSetEditorManager;
    @Mock
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    @Mock
    protected FilterPagedTable filterPagedTable;
    @Mock
    protected DataSetProcessInstanceWithVariablesListPresenter presenter;
    private ProcessInstancesWithVariableListViewExtension view;

    @Before
    public void setupMocks() {
        this.view = new ProcessInstancesWithVariableListViewExtension();
        this.view.setUpMocks(this.currentListGrid, this.filterPagedTable, this.dataSetEditorManager, this.presenter);
        Mockito.when((Object)this.filterPagedTable.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStore);
    }

    @Test
    public void testDataStoreNameIsSet() {
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(new ArrayList());
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testInitDefaultFilters() {
        this.view.initDefaultFilters(new GridGlobalPreferences("testGrid", new ArrayList(), new ArrayList()), null);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).addTab((PagedTable)((ExtendedPagedTable)Mockito.any()), Mockito.anyString(), (Command)Mockito.any());
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).saveNewTabSettings(Mockito.anyString(), (HashMap)Mockito.any());
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        this.view.resetDefaultFilterTitleAndDescription();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).saveTabSettings(Mockito.anyString(), (HashMap)Mockito.any(HashMap.class));
    }
}

