/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.details.basic;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.model.ProcessDefinitionKey;
import org.jbpm.console.ng.bd.model.ProcessSummary;
import org.jbpm.console.ng.pr.client.editors.definition.details.BaseProcessDefDetailsPresenter;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;

@Dependent
public class BasicProcessDefDetailsPresenter
extends BaseProcessDefDetailsPresenter {
    @Inject
    private BasicProcessDefDetailsView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Override
    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    protected void refreshView(String serverTemplateId, String currentProcessDefId, String currentDeploymentId) {
        this.view.getProcessIdText().setText(currentProcessDefId);
        this.view.getDeploymentIdText().setText(currentDeploymentId);
    }

    private void refreshProcessItems(String serverTemplateId, String deploymentId, String processId) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    BasicProcessDefDetailsPresenter.this.view.setEncodedProcessSource(process.getEncodedProcessSource());
                    BasicProcessDefDetailsPresenter.this.view.getProcessNameText().setText(process.getName());
                    BasicProcessDefDetailsPresenter.this.changeStyleRow(process.getName(), process.getVersion());
                } else {
                    BasicProcessDefDetailsPresenter.this.view.setEncodedProcessSource(null);
                    BasicProcessDefDetailsPresenter.this.view.setProcessAssetPath(null);
                }
            }
        })).getProcess(serverTemplateId, new ProcessDefinitionKey(serverTemplateId, deploymentId, processId));
    }

    @Override
    protected void refreshProcessDef(String serverTemplateId, String deploymentId, String processId) {
        this.refreshProcessItems(serverTemplateId, deploymentId, processId);
    }

    public static interface BasicProcessDefDetailsView
    extends BaseProcessDefDetailsPresenter.BaseProcessDefDetailsView {
    }
}

