/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.display.displayers.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.ga.forms.display.FormDisplayerConfig;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.ActionRequest;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.JSNIHelper;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayer;
import org.jbpm.console.ng.pr.forms.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractStartProcessFormDisplayer
implements StartProcessFormDisplayer {
    public static final String ACTION_START_PROCESS = "startProcess";
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected FormPanel container = (FormPanel)GWT.create(FormPanel.class);
    protected FlowPanel formContainer = (FlowPanel)GWT.create(FlowPanel.class);
    protected FlowPanel footerButtons = (FlowPanel)GWT.create(FlowPanel.class);
    protected TextBox correlationKey = (TextBox)GWT.create(TextBox.class);
    protected Label correlationKeyLabel;
    protected String formContent;
    protected String deploymentId;
    protected String processDefId;
    protected String processName;
    protected String opener;
    protected FormContentResizeListener resizeListener;
    protected Long parentProcessInstanceId;
    private Command onClose;
    private Command onRefresh;
    @Inject
    protected ErrorPopupPresenter errorPopup;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    protected Event<NewProcessInstanceEvent> newProcessInstanceEvent;
    protected Caller<KieSessionEntryPoint> sessionServices;
    @Inject
    protected JSNIHelper jsniHelper;
    @Inject
    private Event<NotificationEvent> notificationEvent;

    @PostConstruct
    protected void init() {
        this.container.getElement().setId("form-data");
    }

    public void init(FormDisplayerConfig<ProcessDefinitionKey> config, Command onClose, Command onRefreshCommand, FormContentResizeListener resizeContentListener) {
        this.deploymentId = ((ProcessDefinitionKey)config.getKey()).getDeploymentId();
        this.processDefId = ((ProcessDefinitionKey)config.getKey()).getProcessId();
        this.formContent = config.getFormContent();
        this.opener = config.getFormOpener();
        this.onClose = onClose;
        this.onRefresh = onRefreshCommand;
        this.resizeListener = resizeContentListener;
        this.container.clear();
        this.formContainer.clear();
        this.footerButtons.clear();
        this.container.add((Widget)this.formContainer);
        this.correlationKey = new TextBox();
        Button startButton = new Button(this.constants.Submit(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractStartProcessFormDisplayer.this.startProcessFromDisplayer();
            }
        });
        startButton.setType(ButtonType.PRIMARY);
        this.footerButtons.add((Widget)startButton);
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary summary) {
                AbstractStartProcessFormDisplayer.this.processName = summary.getProcessDefName();
                FocusPanel wrapperFlowPanel = new FocusPanel();
                wrapperFlowPanel.setStyleName("wrapper form-actions");
                if (AbstractStartProcessFormDisplayer.this.opener != null) {
                    AbstractStartProcessFormDisplayer.this.injectEventListener(AbstractStartProcessFormDisplayer.this);
                }
                AbstractStartProcessFormDisplayer.this.initDisplayer();
                AbstractStartProcessFormDisplayer.this.doResize();
            }
        })).getProcessDesc(this.deploymentId, this.processDefId);
    }

    protected abstract void initDisplayer();

    public void doResize() {
        if (this.resizeListener != null) {
            this.resizeListener.resize(this.formContainer.getOffsetWidth(), this.formContainer.getOffsetHeight());
        }
    }

    protected ErrorCallback<Message> getUnexpectedErrorCallback() {
        return new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                String notification = Constants.INSTANCE.UnexpectedError(throwable.getMessage());
                AbstractStartProcessFormDisplayer.this.errorPopup.showMessage(notification);
                AbstractStartProcessFormDisplayer.this.jsniHelper.notifyErrorMessage(AbstractStartProcessFormDisplayer.this.opener, notification);
                return true;
            }
        };
    }

    public Panel getContainer() {
        return this.container;
    }

    public IsWidget getFooter() {
        return this.footerButtons;
    }

    @Override
    public void startProcess(Map<String, Object> params) {
        if (this.parentProcessInstanceId > 0L) {
            ((KieSessionEntryPoint)this.sessionServices.call(this.getStartProcessRemoteCallback(), this.getUnexpectedErrorCallback())).startProcess(this.deploymentId, this.processDefId, this.correlationKey.getValue(), params, this.parentProcessInstanceId);
        } else {
            ((KieSessionEntryPoint)this.sessionServices.call(this.getStartProcessRemoteCallback(), this.getUnexpectedErrorCallback())).startProcess(this.deploymentId, this.processDefId, this.correlationKey.getValue(), params);
        }
    }

    protected RemoteCallback<Long> getStartProcessRemoteCallback() {
        return new RemoteCallback<Long>(){

            public void callback(Long processInstanceId) {
                AbstractStartProcessFormDisplayer.this.newProcessInstanceEvent.fire((Object)new NewProcessInstanceEvent(AbstractStartProcessFormDisplayer.this.deploymentId, processInstanceId, AbstractStartProcessFormDisplayer.this.processDefId, AbstractStartProcessFormDisplayer.this.processName, Integer.valueOf(1)));
                String message = Constants.INSTANCE.ProcessStarted(processInstanceId);
                AbstractStartProcessFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractStartProcessFormDisplayer.this.opener, message);
                AbstractStartProcessFormDisplayer.this.notificationEvent.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.SUCCESS));
                AbstractStartProcessFormDisplayer.this.close();
            }
        };
    }

    public void addOnCloseCallback(Command callback) {
        this.onClose = callback;
    }

    public void addOnRefreshCallback(Command callback) {
        this.onRefresh = callback;
    }

    @Override
    public void addResizeFormContent(FormContentResizeListener resizeListener) {
        this.resizeListener = resizeListener;
    }

    public void close() {
        if (this.onClose != null) {
            this.onClose.execute();
        }
        this.clearStatus();
    }

    protected void clearStatus() {
        this.formContent = null;
        this.opener = null;
        this.deploymentId = null;
        this.processDefId = null;
        this.processName = null;
        this.container.clear();
        this.formContainer.clear();
        this.footerButtons.clear();
        this.onClose = null;
        this.onRefresh = null;
        this.resizeListener = null;
    }

    protected void eventListener(String origin, String request) {
        if (origin == null || !origin.endsWith("//" + this.opener)) {
            return;
        }
        ActionRequest actionRequest = (ActionRequest)JsonUtils.safeEval((String)request);
        if (ACTION_START_PROCESS.equals(actionRequest.getAction())) {
            this.startProcessFromDisplayer();
        }
    }

    private native void injectEventListener(AbstractStartProcessFormDisplayer var1);

    public String getOpener() {
        return this.opener;
    }

    protected String getCorrelationKey() {
        return this.correlationKey.getText();
    }

    public Long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(Long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    @Inject
    public void setSessionServices(Caller<KieSessionEntryPoint> sessionServices) {
        this.sessionServices = sessionServices;
    }
}

