/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.display.providers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.console.ng.ga.forms.display.FormDisplayerConfig;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.ga.forms.service.FormServiceEntryPoint;
import org.jbpm.console.ng.gc.forms.client.display.GenericFormDisplayer;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.gc.forms.client.display.views.GenericFormDisplayView;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayProvider;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayer;
import org.jbpm.console.ng.pr.forms.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class StartProcessFormDisplayProviderImpl
implements StartProcessFormDisplayProvider {
    protected Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected SyncBeanManager iocManager;
    @Inject
    private GenericFormDisplayView view;
    @Inject
    private Caller<FormServiceEntryPoint> formServices;
    private String currentProcessId;
    private String currentDeploymentId;
    protected String opener;
    private Command onClose;
    private Command onRefresh;
    private List<StartProcessFormDisplayer> processDisplayers = new ArrayList<StartProcessFormDisplayer>();
    private FormContentResizeListener resizeListener;

    @PostConstruct
    public void init() {
        this.processDisplayers.clear();
        Collection processDisplayersBeans = this.iocManager.lookupBeans(StartProcessFormDisplayer.class);
        if (processDisplayersBeans != null) {
            for (SyncBeanDef displayerDef : processDisplayersBeans) {
                this.processDisplayers.add((StartProcessFormDisplayer)displayerDef.getInstance());
            }
        }
        Collections.sort(this.processDisplayers, new Comparator<StartProcessFormDisplayer>(){

            @Override
            public int compare(StartProcessFormDisplayer o1, StartProcessFormDisplayer o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void setup(ProcessDisplayerConfig config, FormDisplayerView view) {
        this.display(config, view);
    }

    protected void display(final ProcessDisplayerConfig config, final FormDisplayerView view) {
        if (this.processDisplayers != null) {
            ((FormServiceEntryPoint)this.formServices.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(String form) {
                    for (StartProcessFormDisplayer d : StartProcessFormDisplayProviderImpl.this.processDisplayers) {
                        if (!d.supportsContent(form)) continue;
                        config.setFormContent(form);
                        d.init((FormDisplayerConfig)config, view.getOnCloseCommand(), new Command(){

                            public void execute() {
                                StartProcessFormDisplayProviderImpl.this.display(config, view);
                            }
                        }, view.getResizeListener());
                        view.display((GenericFormDisplayer)d);
                        return;
                    }
                }
            })).getFormDisplayProcess(config.getKey().getDeploymentId(), config.getKey().getProcessId());
        }
    }

    public IsWidget getView() {
        return this.view;
    }
}

