/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.display.views;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.gc.forms.client.display.GenericFormDisplayer;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayProvider;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.mvp.Command;

@Dependent
public class PopupFormDisplayerView
extends BaseModal
implements FormDisplayerView {
    @Inject
    private StartProcessFormDisplayProvider widgetPresenter;
    private Command onCloseCommand;
    private Command childCloseCommand;
    private FormContentResizeListener formContentResizeListener;
    private boolean initialized = false;
    private FlowPanel body = (FlowPanel)GWT.create(FlowPanel.class);
    private ModalFooter footer = (ModalFooter)GWT.create(ModalFooter.class);
    private GenericFormDisplayer currentDisplayer;
    private int initialWidth = -1;

    @PostConstruct
    protected void init() {
        this.onCloseCommand = new Command(){

            public void execute() {
                PopupFormDisplayerView.this.closePopup();
            }
        };
        this.formContentResizeListener = new FormContentResizeListener(){

            public void resize(int width, int height) {
                if (PopupFormDisplayerView.this.initialWidth == -1 && PopupFormDisplayerView.this.getWidget(0).getOffsetWidth() > 0) {
                    PopupFormDisplayerView.this.initialWidth = PopupFormDisplayerView.this.getWidget(0).getOffsetWidth();
                }
                if (width > PopupFormDisplayerView.this.getWidget(0).getOffsetWidth()) {
                    PopupFormDisplayerView.this.setWidth(width + 40 + "px");
                } else if (PopupFormDisplayerView.this.initialWidth != -1) {
                    PopupFormDisplayerView.this.setWidth(PopupFormDisplayerView.this.initialWidth + "px");
                }
            }
        };
        this.setBody((Widget)this.body);
        this.add((Widget)this.footer);
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (PopupFormDisplayerView.this.initialized) {
                    PopupFormDisplayerView.this.closePopup();
                }
            }
        });
    }

    public void display(GenericFormDisplayer displayer) {
        this.currentDisplayer = displayer;
        this.body.clear();
        this.footer.clear();
        this.body.add((Widget)displayer.getContainer());
        if (displayer.getOpener() == null) {
            this.footer.add(displayer.getFooter());
        }
        this.initialized = true;
        this.show();
    }

    public void closePopup() {
        this.hide();
        if (this.childCloseCommand != null) {
            this.childCloseCommand.execute();
        }
        this.setWidth("");
        this.initialized = false;
    }

    public Command getOnCloseCommand() {
        return this.onCloseCommand;
    }

    public void setOnCloseCommand(Command onCloseCommand) {
        this.childCloseCommand = onCloseCommand;
    }

    public FormContentResizeListener getResizeListener() {
        return this.formContentResizeListener;
    }

    public void setResizeListener(FormContentResizeListener resizeListener) {
        this.formContentResizeListener = resizeListener;
    }

    public GenericFormDisplayer getCurrentDisplayer() {
        return this.currentDisplayer;
    }
}

