/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.client.editors.deployment.descriptor;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.console.ng.wi.client.i18n.Constants;
import org.jbpm.console.ng.wi.dd.model.ItemObjectModel;
import org.jbpm.console.ng.wi.dd.model.Parameter;
import org.uberfire.client.views.bs2.modal.Modal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class DDParametersPopup
extends Modal {
    private static DDParametersPopupBinder uiBinder = (DDParametersPopupBinder)GWT.create(DDParametersPopupBinder.class);
    @UiField
    ControlGroup parametersGroup;
    @UiField
    CellTable<Parameter> parametersTable;
    @UiField
    HelpInline parametersHelpInline;
    @UiField
    Button addParameterButton;
    @UiField
    ControlLabel parametersLabel;
    private Command callbackCommand;
    private ListDataProvider<Parameter> parametersDataProvider = new ListDataProvider();
    private final Command okCommand = new Command(){

        public void execute() {
            if (DDParametersPopup.this.callbackCommand != null) {
                DDParametersPopup.this.callbackCommand.execute();
            }
            DDParametersPopup.this.hide();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            DDParametersPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public DDParametersPopup() {
        this.setTitle(Constants.INSTANCE.DDParametersPopupTitle());
        this.setBackdrop(BackdropType.STATIC);
        this.setKeyboard(true);
        this.setAnimation(true);
        this.setDynamicSafe(true);
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.configureParametersTable();
        this.add((Widget)this.footer);
    }

    public void setContent(Command callbackCommand, ItemObjectModel model) {
        this.callbackCommand = callbackCommand;
        this.parametersLabel.setTitle(Constants.INSTANCE.DeploymentDescriptorParameters() + model.getName());
        this.parametersDataProvider.getList().clear();
        if (model.getParameters() != null) {
            this.parametersDataProvider.setList(model.getParameters());
        }
        this.parametersDataProvider.refresh();
    }

    public List<Parameter> getContent() {
        return new ArrayList<Parameter>(this.parametersDataProvider.getList());
    }

    @UiHandler(value={"addParameterButton"})
    public void onClickAddParameterButton(ClickEvent event) {
        this.parametersDataProvider.getList().add(new Parameter("java.lang.String", ""));
    }

    private void configureParametersTable() {
        this.parametersTable.setStriped(true);
        this.parametersTable.setCondensed(true);
        this.parametersTable.setBordered(true);
        this.parametersTable.setEmptyTableWidget((Widget)new Label(Constants.INSTANCE.NoDataDefined()));
        Column<Parameter, String> typeColumn = new Column<Parameter, String>((Cell)new EditTextCell()){

            public String getValue(Parameter item) {
                return item.getType();
            }
        };
        typeColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Parameter, String>(){

            public void update(int index, Parameter object, String value) {
                if (value.equals("")) {
                    return;
                }
                object.setType(value);
            }
        });
        Column<Parameter, String> valueColumn = new Column<Parameter, String>((Cell)new EditTextCell()){

            public String getValue(Parameter item) {
                return item.getValue();
            }
        };
        valueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Parameter, String>(){

            public void update(int index, Parameter object, String value) {
                if (value.equals("")) {
                    return;
                }
                object.setValue(value);
            }
        });
        ButtonCell deleteMSButton = new ButtonCell(ButtonSize.SMALL);
        deleteMSButton.setType(ButtonType.DANGER);
        deleteMSButton.setIcon(IconType.MINUS_SIGN);
        Column<Parameter, String> deleteGlobalColumn = new Column<Parameter, String>((Cell)deleteMSButton){

            public String getValue(Parameter item) {
                return Constants.INSTANCE.Remove();
            }
        };
        deleteGlobalColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Parameter, String>(){

            public void update(int index, Parameter item, String value) {
                if (Window.confirm((String)Constants.INSTANCE.PromptForRemoval())) {
                    DDParametersPopup.this.parametersDataProvider.getList().remove(index);
                }
            }
        });
        this.parametersTable.addColumn((Column)typeColumn, (Header)new TextHeader(Constants.INSTANCE.Type()));
        this.parametersTable.addColumn((Column)valueColumn, (Header)new TextHeader(Constants.INSTANCE.Value()));
        this.parametersTable.addColumn((Column)deleteGlobalColumn, Constants.INSTANCE.Remove());
        this.parametersDataProvider.addDataDisplay(this.parametersTable);
    }

    static interface DDParametersPopupBinder
    extends UiBinder<Widget, DDParametersPopup> {
    }
}

