/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.designer.client.popup.ActivityDataIOEditorViewImpl;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityDataIOEditorViewImplTest {
    @Mock
    private ActivityDataIOEditorWidget inputAssignmentsWidget;
    @Mock
    private ActivityDataIOEditorWidget outputAssignmentsWidget;
    @Captor
    private ArgumentCaptor<List<AssignmentRow>> listAssignmentCaptor;
    @GwtMock
    private ActivityDataIOEditorViewImpl view;
    private List<AssignmentRow> rows;

    @Before
    public void setUp() {
        this.view.inputAssignmentsWidget = this.inputAssignmentsWidget;
        this.view.outputAssignmentsWidget = this.outputAssignmentsWidget;
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setInputAssignmentRows((List)Mockito.any(List.class));
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setOutputAssignmentRows((List)Mockito.any(List.class));
        this.rows = new ArrayList<AssignmentRow>();
        this.rows.add(new AssignmentRow("varName", null, null, null, "varName", null));
        this.rows.add(new AssignmentRow("varName2", null, null, null, "varName2", null));
    }

    @Test
    public void testInputAssignmentsRowsSameSourceAndTargetName() {
        this.view.setInputAssignmentRows(this.rows);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.times((int)1))).setData((List)this.listAssignmentCaptor.capture());
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.never())).setData((List)Mockito.any(List.class));
        this.verifyForSameSourceAndTargetName();
    }

    @Test
    public void testOutputAssignmentsRowsSameSourceAndTargetName() {
        this.view.setOutputAssignmentRows(this.rows);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.times((int)1))).setData((List)this.listAssignmentCaptor.capture());
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.never())).setData((List)Mockito.any(List.class));
        this.verifyForSameSourceAndTargetName();
    }

    private void verifyForSameSourceAndTargetName() {
        Assert.assertEquals((long)2L, (long)((List)this.listAssignmentCaptor.getValue()).size());
        Assert.assertEquals((Object)this.rows.get(0), ((List)this.listAssignmentCaptor.getValue()).get(0));
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(0)).getProcessVar());
        Assert.assertEquals((Object)this.rows.get(1), ((List)this.listAssignmentCaptor.getValue()).get(1));
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(1)).getProcessVar());
    }
}

