/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.popup.ActivityDataIOEditorView;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityDataIOEditorTest {
    @Captor
    private ArgumentCaptor<Set<String>> setCaptor;
    @Captor
    private ArgumentCaptor<List<String>> listCaptorOne;
    @Captor
    private ArgumentCaptor<List<String>> listCaptorTwo;
    @Captor
    ArgumentCaptor<List<AssignmentRow>> listAssignmentCaptor;
    @Mock
    private ActivityDataIOEditorView ioEditorView;
    @Spy
    @InjectMocks
    private ActivityDataIOEditor ioEditor = new ActivityDataIOEditor();

    @Test
    public void testInitIoEditor() {
        this.ioEditor.init();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.times((int)1))).init((ActivityDataIOEditorView.Presenter)this.ioEditor);
    }

    @Test
    public void testSaveClickCallback() {
        AssignmentRow row = new AssignmentRow("name", Variable.VariableType.INPUT, "String", "Object", "var", "constant");
        ArrayList<AssignmentRow> input = new ArrayList<AssignmentRow>();
        input.add(row);
        ArrayList<AssignmentRow> output = new ArrayList<AssignmentRow>();
        output.add(row);
        Mockito.when((Object)this.ioEditorView.getInputAssignmentData()).thenReturn(input);
        Mockito.when((Object)this.ioEditorView.getOutputAssignmentData()).thenReturn(output);
        ArrayList<String> dataTypes = new ArrayList<String>();
        ArrayList<String> dataTypesDisplayNames = new ArrayList<String>();
        dataTypes.add("a.b.c.Name");
        dataTypesDisplayNames.add("Name");
        ActivityDataIOEditor.GetDataCallback mockCallback = (ActivityDataIOEditor.GetDataCallback)Mockito.mock(ActivityDataIOEditor.GetDataCallback.class);
        this.ioEditor.setCallback(mockCallback);
        try {
            this.ioEditor.handleSaveClick();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).getInputAssignmentData();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).getOutputAssignmentData();
    }

    @Test
    public void testSaveClickHide() {
        this.ioEditor.handleSaveClick();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).hideView();
    }

    @Test
    public void testCancelClick() {
        ActivityDataIOEditor.GetDataCallback mockCallback = (ActivityDataIOEditor.GetDataCallback)Mockito.mock(ActivityDataIOEditor.GetDataCallback.class);
        this.ioEditor.setCallback(mockCallback);
        this.ioEditor.handleCancelClick();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).hideView();
        ((ActivityDataIOEditor.GetDataCallback)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.never())).getData(Mockito.anyString());
    }

    @Test
    public void testPossibleDataTypes() {
        ArrayList<String> dataTypes = new ArrayList<String>();
        ArrayList<String> dataTypesDisplayNames = new ArrayList<String>();
        dataTypes.add("a.b.c.Name");
        dataTypesDisplayNames.add("Name");
        this.ioEditor.setDataTypes(dataTypes, dataTypesDisplayNames);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setPossibleInputAssignmentsDataTypes((List)this.listCaptorOne.capture(), (List)this.listCaptorTwo.capture());
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorOne.getValue()).size());
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorTwo.getValue()).size());
        Assert.assertEquals(dataTypes.get(0), ((List)this.listCaptorOne.getValue()).get(0));
        Assert.assertEquals(dataTypesDisplayNames.get(0), ((List)this.listCaptorTwo.getValue()).get(0));
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setPossibleOutputAssignmentsDataTypes((List)this.listCaptorOne.capture(), (List)this.listCaptorTwo.capture());
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorOne.getValue()).size());
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorTwo.getValue()).size());
        Assert.assertEquals(dataTypes.get(0), ((List)this.listCaptorOne.getValue()).get(0));
        Assert.assertEquals(dataTypesDisplayNames.get(0), ((List)this.listCaptorTwo.getValue()).get(0));
    }

    @Test
    public void testConfigureDialogBoolean() {
        this.ioEditor.configureDialog("task name", true, false, true, false);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setInputAssignmentsVisibility(true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setIsInputAssignmentSingleVar(false);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setOutputAssignmentsVisibility(true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setIsOutputAssignmentSingleVar(false);
        this.ioEditor.configureDialog("task name", false, true, false, true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setInputAssignmentsVisibility(false);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setIsInputAssignmentSingleVar(true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setOutputAssignmentsVisibility(false);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setIsOutputAssignmentSingleVar(true);
    }

    @Test
    public void testConfigureDialogTaskNameEmpty() {
        this.ioEditor.configureDialog("", true, true, true, true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.times((int)1))).setDefaultViewTitle();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.never())).setCustomViewTitle(Mockito.anyString());
    }

    @Test
    public void testConfigureDialogTaskNameNull() {
        this.ioEditor.configureDialog(null, true, true, true, true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.times((int)1))).setDefaultViewTitle();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.never())).setCustomViewTitle(Mockito.anyString());
    }

    @Test
    public void testConfigureDialogTaskNameCustom() {
        this.ioEditor.configureDialog("abc", true, true, true, true);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.times((int)1))).setCustomViewTitle("abc");
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.never())).setDefaultViewTitle();
    }

    @Test
    public void testDisallowedPropertyNames() {
        ArrayList<String> disallowedNames = new ArrayList<String>();
        disallowedNames.add("Abc");
        disallowedNames.add("xyZ");
        this.ioEditor.setDisallowedPropertyNames(disallowedNames);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setInputAssignmentsDisallowedNames((Set)this.setCaptor.capture());
        Assert.assertEquals((String)"should be 2 disallowed names", (long)2L, (long)((Set)this.setCaptor.getValue()).size());
        Assert.assertTrue((String)"disallowed names should contain: abc", (boolean)((Set)this.setCaptor.getValue()).contains("abc"));
        Assert.assertTrue((String)"disallowed names should contain: xyz", (boolean)((Set)this.setCaptor.getValue()).contains("xyz"));
    }

    @Test
    public void testProcessVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("variable");
        this.ioEditor.setProcessVariables(variables);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setInputAssignmentsProcessVariables((List)this.listCaptorOne.capture());
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorOne.getValue()).size());
        Assert.assertEquals(variables.get(0), ((List)this.listCaptorOne.getValue()).get(0));
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setOutputAssignmentsProcessVariables(variables);
        Assert.assertEquals((long)1L, (long)((List)this.listCaptorOne.getValue()).size());
        Assert.assertEquals(variables.get(0), ((List)this.listCaptorOne.getValue()).get(0));
    }

    @Test
    public void testInputAssignmentsRows() {
        AssignmentRow row = (AssignmentRow)Mockito.mock(AssignmentRow.class);
        ArrayList<AssignmentRow> rows = new ArrayList<AssignmentRow>();
        rows.add(row);
        this.ioEditor.setInputAssignmentRows(rows);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setInputAssignmentRows((List)this.listAssignmentCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.listAssignmentCaptor.getValue()).size());
        Assert.assertEquals(rows.get(0), ((List)this.listAssignmentCaptor.getValue()).get(0));
    }

    @Test
    public void testOutputAssignmentsRows() {
        AssignmentRow row = (AssignmentRow)Mockito.mock(AssignmentRow.class);
        ArrayList<AssignmentRow> rows = new ArrayList<AssignmentRow>();
        rows.add(row);
        this.ioEditor.setOutputAssignmentRows(rows);
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).setOutputAssignmentRows((List)this.listAssignmentCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.listAssignmentCaptor.getValue()).size());
        Assert.assertEquals(rows.get(0), ((List)this.listAssignmentCaptor.getValue()).get(0));
    }

    @Test
    public void testShow() {
        this.ioEditor.show();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView)).showView();
        ((ActivityDataIOEditorView)Mockito.verify((Object)this.ioEditorView, (VerificationMode)Mockito.never())).hideView();
    }
}

