/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jbpm.designer.client.shared.Assignment;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StringUtils.class})
public class AssignmentTest {
    AssignmentData ad = (AssignmentData)Mockito.mock(AssignmentData.class);

    @Before
    public void setUp() {
        PowerMockito.mockStatic(StringUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)StringUtils.urlEncode((String)Mockito.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return AssignmentTest.this.urlEncode((String)args[0]);
            }
        });
        PowerMockito.when((Object)StringUtils.urlDecode((String)Mockito.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return AssignmentTest.this.urlDecode((String)args[0]);
            }
        });
    }

    @Test
    public void testSerializeDeserialize() {
        Assignment a = new Assignment(this.ad, "input1", Variable.VariableType.INPUT, "String", null, null, null);
        this.serializeDeserialize(this.ad, a, "-_.!~*'( )  ");
        this.serializeDeserialize(this.ad, a, ";/?:&=+$,#");
        this.serializeDeserialize(this.ad, a, "http://www.test.com/getit?a=1&b=2");
        this.serializeDeserialize(this.ad, a, "a,b=c:aa,,bb==cc");
        this.serializeDeserialize(this.ad, a, "a|=b=|c:a[=b=[c:a]=b=]c");
        this.serializeDeserialize(this.ad, a, "C:\\home\\joe bloggs\\test\\stuff.txt");
        this.serializeDeserialize(this.ad, a, "a bb  ");
    }

    public void serializeDeserialize(AssignmentData ad, Assignment assignment, String constant) {
        assignment.setConstant(constant);
        String s = assignment.toString();
        Assignment newA = Assignment.deserialize((AssignmentData)ad, (String)s);
        String deserializedConstant = newA.getConstant();
        Assert.assertEquals((Object)constant, (Object)deserializedConstant);
    }

    @Test
    public void testDeserialize() {
        Assignment a = new Assignment(this.ad, "input1", Variable.VariableType.INPUT, "String", null, null, null);
        this.deserialize(this.ad, a, "-_.!~*'( )", "-_.!~*'(+)", "-_.%21%7E*%27%28+%29");
        this.deserialize(this.ad, a, ";/?:&=+$,#", "%3B%2F%3F%3A%26%3D%2B%24%2C%23", "%3B%2F%3F%3A%26%3D%2B%24%2C%23");
        this.deserialize(this.ad, a, "http://www.test.com/getit?a=1&b=2", "http%3A%2F%2Fwww.test.com%2Fgetit%3Fa%3D1%26b%3D2", "http%3A%2F%2Fwww.test.com%2Fgetit%3Fa%3D1%26b%3D2");
        this.deserialize(this.ad, a, "a,b=c:aa,,bb==cc", "a%2Cb%3Dc%3Aaa%2C%2Cbb%3D%3Dcc", "a%2Cb%3Dc%3Aaa%2C%2Cbb%3D%3Dcc");
        this.deserialize(this.ad, a, "a|=b=|c:a[=b=[c:a]=b=]c", "a%7C%3Db%3D%7Cc%3Aa%5B%3Db%3D%5Bc%3Aa%5D%3Db%3D%5Dc", "a%7C%3Db%3D%7Cc%3Aa%5B%3Db%3D%5Bc%3Aa%5D%3Db%3D%5Dc");
        this.deserialize(this.ad, a, "C:\\home\\joe bloggs\\test\\stuff.txt", "C%3A%5Chome%5Cjoe+bloggs%5Ctest%5Cstuff.txt", "C%3A%5Chome%5Cjoe+bloggs%5Ctest%5Cstuff.txt");
        this.deserialize(this.ad, a, "a bb  ", "a+bb++", "a%20bb%20%20");
        this.deserialize(this.ad, a, "a+bb++", "a%2Bbb%2B%2B", "a%2Bbb%2B%2B");
        this.deserialize(this.ad, a, "a+ a +bb++  bb  ++", "a%2B%20a%20%2Bbb%2B%2B%20%20bb%20%20%2B%2B", "a%2B%20a%20%2Bbb%2B%2B%20%20bb%20%20%2B%2B");
    }

    public void deserialize(AssignmentData ad, Assignment assignment, String constant, String jsonEncodedConstant, String bpmn2EncodedConstant) {
        assignment.setConstant(constant);
        String s = assignment.toString();
        s = s.replace(bpmn2EncodedConstant, jsonEncodedConstant);
        Assignment newA = Assignment.deserialize((AssignmentData)ad, (String)s);
        String deserializedConstant = newA.getConstant();
        Assert.assertEquals((Object)constant, (Object)deserializedConstant);
    }

    public String urlEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public String urlDecode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

