/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jbpm.designer.client.DesignerPopUpPresenter;
import org.jbpm.designer.client.DesignerViewImpl;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.jbpm.designer.client.DesignerWidgetView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class OnResizeTest {
    @Spy
    private DesignerWidgetView designerWidgetView;
    @Spy
    private DesignerPopUpPresenter designerPopupPresenter;
    @Spy
    private DesignerViewImpl designerViewImpl;
    @GwtMock
    Widget parentWidget;
    @GwtMock
    FlowPanel parentContaner;
    @GwtMock
    DesignerWidgetPresenter designerWidgetPresenter;

    @Test
    public void testDesignerWidgetViewOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerWidgetView.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(Integer.class);
        this.designerWidgetView.onResize();
        ((DesignerWidgetView)Mockito.verify((Object)this.designerWidgetView, (VerificationMode)Mockito.times((int)1))).setPixelSize(((Integer)pixelSizeCaptorWidth.capture()).intValue(), ((Integer)pixelSizeCaptorHeight.capture()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorWidth.getValue()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorHeight.getValue()).intValue());
    }

    @Test
    public void testDesignerPopupPresenterOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerPopupPresenter.getContainer()).thenReturn((Object)this.parentContaner);
        Mockito.when((Object)this.parentContaner.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(String.class);
        this.designerPopupPresenter.onResize();
        ((FlowPanel)Mockito.verify((Object)this.parentContaner, (VerificationMode)Mockito.times((int)1))).setWidth((String)pixelSizeCaptorWidth.capture());
        ((FlowPanel)Mockito.verify((Object)this.parentContaner, (VerificationMode)Mockito.times((int)1))).setHeight((String)pixelSizeCaptorHeight.capture());
        Assert.assertEquals((Object)"100px", (Object)pixelSizeCaptorWidth.getValue());
        Assert.assertEquals((Object)"100px", (Object)pixelSizeCaptorHeight.getValue());
    }

    @Test
    public void testDesignerViewImplOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerViewImpl.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)this.designerWidgetPresenter.getView()).thenReturn((Object)this.designerWidgetView);
        this.designerViewImpl.setDesignerWidget(this.designerWidgetPresenter);
        this.designerViewImpl.onResize();
        ((DesignerViewImpl)Mockito.verify((Object)this.designerViewImpl, (VerificationMode)Mockito.times((int)1))).setPixelSize(((Integer)pixelSizeCaptorWidth.capture()).intValue(), ((Integer)pixelSizeCaptorHeight.capture()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorWidth.getValue()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorHeight.getValue()).intValue());
        ((DesignerWidgetView)Mockito.verify((Object)this.designerWidgetView, (VerificationMode)Mockito.times((int)1))).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }
}

