/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetView;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityDataIOEditorWidgetTest {
    private AssignmentRow assignmentRowOne = new AssignmentRow("aBc", null, null, null, "aBc", "AbC");
    private AssignmentRow assignmentRowTwo = new AssignmentRow("aBc", null, null, null, "aBc", "abc");
    private AssignmentRow assignmentRowThree = new AssignmentRow("def", null, null, null, "def", null);
    @Mock
    private AssignmentListItemWidgetViewImpl assignWidgetOne;
    @Mock
    private AssignmentListItemWidgetViewImpl assignWidgetTwo;
    @Mock
    private AssignmentListItemWidgetViewImpl assignWidgetThree;
    @Mock
    private ActivityDataIOEditorWidgetView view;
    @Captor
    private ArgumentCaptor<List<AssignmentRow>> captor;
    @Spy
    @InjectMocks
    private ActivityDataIOEditorWidget widget = new ActivityDataIOEditorWidget();
    private List<AssignmentRow> rows;

    @Before
    public void initTestCase() {
        this.rows = new ArrayList<AssignmentRow>();
        this.rows.add(this.assignmentRowOne);
        this.rows.add(this.assignmentRowTwo);
        this.rows.add(this.assignmentRowThree);
        Mockito.when((Object)this.view.getAssignmentRows()).thenReturn(this.rows);
        Mockito.when((Object)this.view.getAssignmentsCount()).thenReturn((Object)this.rows.size());
        Mockito.when((Object)this.view.getAssignmentWidget(0)).thenReturn((Object)this.assignWidgetOne);
        Mockito.when((Object)this.view.getAssignmentWidget(1)).thenReturn((Object)this.assignWidgetTwo);
        Mockito.when((Object)this.view.getAssignmentWidget(2)).thenReturn((Object)this.assignWidgetThree);
    }

    @Test
    public void testInit() {
        this.widget.init();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).init((ActivityDataIOEditorWidgetView.Presenter)this.widget);
    }

    @Test
    public void testAddHandlerSingleFull() {
        this.widget.setIsSingleVar(true);
        this.widget.handleAddClick();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).showOnlySingleEntryAllowed();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(Mockito.anyInt());
    }

    @Test
    public void testAddHandlerSingle() {
        this.rows.clear();
        Mockito.when((Object)this.view.getAssignmentRows()).thenReturn(this.rows);
        Mockito.when((Object)this.view.getAssignmentsCount()).thenReturn((Object)1);
        this.widget.setIsSingleVar(true);
        this.widget.handleAddClick();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showOnlySingleEntryAllowed();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(2);
    }

    @Test
    public void testAddHandlerMultiple() {
        this.rows.remove(this.assignmentRowThree);
        Mockito.when((Object)this.view.getAssignmentRows()).thenReturn(this.rows);
        Mockito.when((Object)this.view.getAssignmentsCount()).thenReturn((Object)3);
        this.widget.setIsSingleVar(false);
        this.widget.handleAddClick();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showOnlySingleEntryAllowed();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(2);
    }

    @Test
    public void testSingleVarInput() {
        this.widget.setVariableType(Variable.VariableType.INPUT);
        this.widget.setIsSingleVar(true);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setProcessVarAsSource();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableTitleInputSingle();
    }

    @Test
    public void testMultipleVarInput() {
        this.widget.setVariableType(Variable.VariableType.INPUT);
        this.widget.setIsSingleVar(false);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setProcessVarAsSource();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableTitleInputMultiple();
    }

    @Test
    public void testSingleVarOutput() {
        this.widget.setVariableType(Variable.VariableType.OUTPUT);
        this.widget.setIsSingleVar(true);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setProcessVarAsTarget();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableTitleOutputSingle();
    }

    @Test
    public void testMultipleVarOutput() {
        this.widget.setVariableType(Variable.VariableType.OUTPUT);
        this.widget.setIsSingleVar(false);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setProcessVarAsTarget();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableTitleOutputMultiple();
    }

    @Test
    public void testRemoveAssignmentEmpty() {
        this.widget.removeAssignment(this.assignmentRowOne);
        this.widget.removeAssignment(this.assignmentRowTwo);
        this.widget.removeAssignment(this.assignmentRowThree);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setNoneDisplayStyle();
        Assert.assertEquals((long)0L, (long)this.view.getAssignmentRows().size());
    }

    @Test
    public void testRemoveAssignmentNonEmpty() {
        this.widget.removeAssignment(this.assignmentRowOne);
        this.widget.removeAssignment(this.assignmentRowThree);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNoneDisplayStyle();
        Assert.assertEquals((long)1L, (long)this.view.getAssignmentRows().size());
        Assert.assertEquals((Object)this.assignmentRowTwo, this.view.getAssignmentRows().get(0));
    }

    @Test
    public void testSetDataEmpty() {
        this.rows.clear();
        this.widget.setData(this.rows);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setNoneDisplayStyle();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setAssignmentRows((List)this.captor.capture());
        Assert.assertEquals((long)0L, (long)((List)this.captor.getValue()).size());
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getAssignmentWidget(Mockito.anyInt());
    }

    @Test
    public void testSetDataNonEmpty() {
        this.widget.setData(this.rows);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableDisplayStyle();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setAssignmentRows((List)this.captor.capture());
        Assert.assertEquals((long)3L, (long)((List)this.captor.getValue()).size());
        Assert.assertTrue((boolean)((List)this.captor.getValue()).contains(this.assignmentRowOne));
        Assert.assertTrue((boolean)((List)this.captor.getValue()).contains(this.assignmentRowTwo));
        Assert.assertTrue((boolean)((List)this.captor.getValue()).contains(this.assignmentRowThree));
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).getAssignmentWidget(2);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setParentWidget(this.widget);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setDisallowedNames(new HashSet(), "");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setAllowDuplicateNames(true, "");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setParentWidget(this.widget);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setDisallowedNames(new HashSet(), "");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setAllowDuplicateNames(true, "");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setParentWidget(this.widget);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setDisallowedNames(new HashSet(), "");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setAllowDuplicateNames(true, "");
    }

    @Test
    public void testSetDataComplex() {
        HashSet<String> disallowed = new HashSet<String>();
        disallowed.add("abc");
        this.widget.setDisallowedNames(disallowed, "message1");
        this.widget.setAllowDuplicateNames(false, "message2");
        this.widget.setData(this.rows);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setTableDisplayStyle();
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setAssignmentRows((List)this.captor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.captor.getValue()).size());
        Assert.assertEquals((Object)this.assignmentRowThree, ((List)this.captor.getValue()).get(0));
        Assert.assertEquals((Object)"def", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"def", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getProcessVar());
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(2);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setParentWidget(this.widget);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne, (VerificationMode)Mockito.times((int)2))).setDisallowedNames(disallowed, "message1");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setAllowDuplicateNames(false, "message2");
    }

    @Test
    public void testGetData() {
        List rows = this.widget.getData();
        Assert.assertEquals((long)3L, (long)rows.size());
        Assert.assertEquals((Object)this.assignmentRowOne, rows.get(0));
        Assert.assertEquals((Object)this.assignmentRowTwo, rows.get(1));
        Assert.assertEquals((Object)this.assignmentRowThree, rows.get(2));
    }

    @Test
    public void testGetDataWithHiddenNotMatch() {
        HashSet<String> disallowed = new HashSet<String>();
        disallowed.add("x");
        this.widget.setDisallowedNames(disallowed, "message");
        this.widget.setData(this.rows);
        List result = this.widget.getData();
        Assert.assertEquals(this.rows, (Object)result);
    }

    @Test
    public void testGetDataWithHiddenMatch() {
        HashSet<String> disallowed = new HashSet<String>();
        disallowed.add("abc");
        this.widget.setDisallowedNames(disallowed, "message");
        this.widget.setData(this.rows);
        List result = this.widget.getData();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(this.assignmentRowOne));
        Assert.assertTrue((boolean)result.contains(this.assignmentRowTwo));
        Assert.assertTrue((boolean)result.contains(this.assignmentRowThree));
        Assert.assertNotEquals(this.rows, (Object)result);
    }

    @Test
    public void testDataTypes() {
        ListBoxValues types = (ListBoxValues)Mockito.mock(ListBoxValues.class);
        this.widget.setDataTypes(types);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(2);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setDataTypes(types);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setDataTypes(types);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setDataTypes(types);
    }

    @Test
    public void testProcessVariables() {
        ListBoxValues variables = (ListBoxValues)Mockito.mock(ListBoxValues.class);
        this.widget.setProcessVariables(variables);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(2);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setProcessVariables(variables);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setProcessVariables(variables);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setProcessVariables(variables);
    }

    @Test
    public void testSetDisallowedNames() {
        Set names = (Set)Mockito.mock(new HashSet().getClass());
        this.widget.setDisallowedNames(names, "message");
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(0);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(1);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).getAssignmentWidget(2);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetOne)).setDisallowedNames(names, "message");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetTwo)).setDisallowedNames(names, "message");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.assignWidgetThree)).setDisallowedNames(names, "message");
    }

    @Test
    public void testIsDuplicateName() {
        Assert.assertTrue((boolean)this.widget.isDuplicateName("aBc"));
        Assert.assertFalse((boolean)this.widget.isDuplicateName("def"));
        Assert.assertFalse((boolean)this.widget.isDuplicateName("q"));
    }

    @Test
    public void testSetIsVisible() {
        this.widget.setIsVisible(true);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setVisible(true);
        this.widget.setIsVisible(false);
        ((ActivityDataIOEditorWidgetView)Mockito.verify((Object)this.view)).setVisible(false);
    }
}

