/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.widget.ListWidget;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetView;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetViewImpl;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityDataIOEditorWidgetViewImplTest {
    @Mock
    ActivityDataIOEditorWidgetView.Presenter presenter;
    @GwtMock
    private Button button;
    @GwtMock
    private ListWidget<AssignmentRow, AssignmentListItemWidgetViewImpl> assignments;
    @GwtMock
    private ActivityDataIOEditorWidgetViewImpl view;
    @Captor
    private ArgumentCaptor<List<AssignmentRow>> captor;
    private List<AssignmentRow> rows;

    @Before
    public void setUp() {
        this.view.assignments = this.assignments;
        this.view.addVarButton = this.button;
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setAssignmentRows((List)Mockito.any(List.class));
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).init((ActivityDataIOEditorWidgetView.Presenter)Mockito.any(ActivityDataIOEditorWidgetView.Presenter.class));
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).handleAddVarButton((ClickEvent)Mockito.any(ClickEvent.class));
        this.rows = new ArrayList<AssignmentRow>();
        this.rows.add(new AssignmentRow("varName", null, null, null, "varName", null));
        this.rows.add(new AssignmentRow("varName2", null, null, null, "varName2", null));
    }

    @Test
    public void testInit() {
        this.view.init(this.presenter);
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.timeout((long)1L))).setText(DesignerEditorConstants.INSTANCE.Add());
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.timeout((long)1L))).setIcon(IconType.PLUS);
    }

    @Test
    public void testHandleAddVarButton() {
        this.view.init(this.presenter);
        this.view.handleAddVarButton((ClickEvent)Mockito.mock(ClickEvent.class));
        ((ActivityDataIOEditorWidgetView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).handleAddClick();
    }

    @Test
    public void testAssignmentsRowsSameSourceAndTarget() {
        this.view.setAssignmentRows(this.rows);
        ((ListWidget)Mockito.verify(this.assignments, (VerificationMode)Mockito.times((int)1))).setValue((List)this.captor.capture());
        Assert.assertEquals((long)2L, (long)((List)this.captor.getValue()).size());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getProcessVar());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.captor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.captor.getValue()).get(1)).getProcessVar());
    }
}

