/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.marshalling.client.api.MarshallingSession;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.server.JSONStreamDecoder;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.AssignmentDataMarshaller;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssignmentDataMarshallerTest {
    private AssignmentDataMarshaller marshaller;
    private List<AssignmentRow> inputs;
    private List<AssignmentRow> outputs;
    private List<String> dataTypes;
    private List<String> dataTypesDisplayNames;
    @Mock
    private MarshallingSession session;

    @Before
    public void setUp() throws Exception {
        this.marshaller = new AssignmentDataMarshaller();
        this.inputs = new ArrayList<AssignmentRow>();
        this.outputs = new ArrayList<AssignmentRow>();
        this.dataTypes = new ArrayList<String>();
        this.dataTypesDisplayNames = new ArrayList<String>();
        this.dataTypes.add("String");
        this.dataTypesDisplayNames.add("String");
        this.dataTypes.add("Integer");
        this.dataTypesDisplayNames.add("Integer");
    }

    @Test
    public void testEmpty() {
        this.marshallAndDemarshall();
    }

    @Test
    public void testInputs() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, "String", null, "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testInputsCustom() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, null, "customStringType", "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testInputsOnlyTaskVar() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, null, null, null, null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testInputsOnlyVars() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, null, null, "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testOutputs() {
        this.outputs.add(new AssignmentRow("name", Variable.VariableType.OUTPUT, "String", null, "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testOutputsCustom() {
        this.outputs.add(new AssignmentRow("name", Variable.VariableType.OUTPUT, null, "customStringType", "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testOutputsOnlyTaskVar() {
        this.outputs.add(new AssignmentRow("name", Variable.VariableType.OUTPUT, null, null, null, null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testOutputsOnlyVars() {
        this.outputs.add(new AssignmentRow("name", Variable.VariableType.OUTPUT, null, null, "varName", null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testConstant() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, "String", null, null, null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testConstantCustom() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, null, "customStringType", null, null));
        this.marshallAndDemarshall();
    }

    @Test
    public void testMultipleAssignments() {
        this.inputs.add(new AssignmentRow("name", Variable.VariableType.INPUT, "String", null, "varName", null));
        this.inputs.add(new AssignmentRow("name2", Variable.VariableType.INPUT, null, "customString", "varName2", null));
        this.inputs.add(new AssignmentRow("name3", Variable.VariableType.INPUT, null, "customString", null, null));
        this.outputs.add(new AssignmentRow("name4", Variable.VariableType.INPUT, "Integer", null, null, null));
        this.outputs.add(new AssignmentRow("onlyname", Variable.VariableType.INPUT, null, null, null, null));
        this.outputs.add(new AssignmentRow("name", Variable.VariableType.OUTPUT, "String", null, "varName", null));
        this.outputs.add(new AssignmentRow("name2", Variable.VariableType.OUTPUT, null, "customString", "varName2", null));
        this.outputs.add(new AssignmentRow("name3", Variable.VariableType.OUTPUT, null, "customString", null, null));
        this.outputs.add(new AssignmentRow("name4", Variable.VariableType.OUTPUT, "Integer", null, null, null));
        this.outputs.add(new AssignmentRow("onlyname", Variable.VariableType.OUTPUT, null, null, null, null));
        this.marshallAndDemarshall();
    }

    private void marshallAndDemarshall() {
        AssignmentData original = new AssignmentData(this.inputs, this.outputs, this.dataTypes, this.dataTypesDisplayNames);
        String json = this.marshaller.marshall((Object)original, this.session);
        EJValue jsonObject = new JSONStreamDecoder((InputStream)new ByteArrayInputStream(json.getBytes())).parse();
        AssignmentData demarshalled = (AssignmentData)this.marshaller.demarshall(jsonObject, this.session);
        Assert.assertEquals((Object)original, (Object)demarshalled);
    }
}

