/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import java.util.Arrays;
import java.util.List;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Assert;
import org.junit.Test;

public class ListBoxValuesTest {
    String sDataTypes1 = "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object, ******:******,UserCommand [org.jbpm.examples.cmd]:org.jbpm.examples.cmd.UserCommand,User [org.jbpm.examples.data]:org.jbpm.examples.data.User,Invoice [org.kie.test]:org.kie.test.Invoice,InvoiceLine [org.kie.test]:org.kie.test.InvoiceLine,PositionTest1 [org.kie.test]:org.kie.test.PositionTest1,PositionTest2 [org.kie.test]:org.kie.test.PositionTest2,PositionTest3 [org.kie.test]:org.kie.test.PositionTest3,PositionTest5 [org.kie.test]:org.kie.test.PositionTest5,SubComponent [org.kie.test]:org.kie.test.SubComponent,TestFormulas [org.kie.test]:org.kie.test.TestFormulas,TestPatterns [org.kie.test]:org.kie.test.TestPatterns,TestTypes [org.kie.test]:org.kie.test.TestTypes,TestTypesLine [org.kie.test]:org.kie.test.TestTypesLine";
    AssignmentData assignmentData1 = new AssignmentData(null, null, null, null, this.sDataTypes1, null);

    @Test
    public void testProcessVarListBoxValues() {
        List<String> processVarStartValues = Arrays.asList("** Variable Definitions **", "employee", "reason", "performance");
        ListBoxValues processVarValues = new ListBoxValues("Constant ...", "Edit ", null);
        processVarValues.addValues(processVarStartValues);
        processVarValues.addCustomValue("\"abc\"", "");
        processVarValues.update("\"abc\"");
        processVarValues.update("reason");
        processVarValues.addCustomValue("\"ghi\"", "");
        processVarValues.update("\"ghi\"");
        processVarValues.addCustomValue("\"def\"", "\"ghi\"");
        processVarValues.update("\"def\"");
        processVarValues.update("reason");
        processVarValues.addCustomValue("\"employee\"", "");
        processVarValues.update("\"employee\"");
        processVarValues.update("performance");
        processVarValues.addCustomValue("123", "");
        processVarValues.update("123");
        processVarValues.update("\"reason\"");
        processVarValues.addCustomValue("\"jkl\"", "\"reason\"");
        processVarValues.update("\"jkl\"");
        Object[] acceptableValuesWithoutCustomValues = new String[]{"** Variable Definitions **", "employee", "reason", "performance"};
        Object[] expectedAcceptableValuesWithCustomValues = new String[]{"", "\"jkl\"", "Edit \"jkl\" ...", "123", "\"employee\"", "\"def\"", "\"abc\"", "Constant ...", "** Variable Definitions **", "employee", "reason", "performance"};
        Assert.assertArrayEquals((Object[])acceptableValuesWithoutCustomValues, (Object[])processVarValues.getAcceptableValuesWithoutCustomValues().toArray());
        Assert.assertArrayEquals((Object[])expectedAcceptableValuesWithCustomValues, (Object[])processVarValues.getAcceptableValuesWithCustomValues().toArray());
    }

    @Test
    public void testDataTypeListBoxValues() {
        ListBoxValues dataTypeValues = new ListBoxValues("Custom ...", "Edit ", new ListBoxValues.ValueTester(){

            public String getNonCustomValueForUserString(String userValue) {
                if (ListBoxValuesTest.this.assignmentData1 != null) {
                    return ListBoxValuesTest.this.assignmentData1.getDataTypeDisplayNameForUserString(userValue);
                }
                return null;
            }
        });
        dataTypeValues.addValues(this.assignmentData1.getDataTypeDisplayNames());
        dataTypeValues.addCustomValue("com.test.MyType", "");
        dataTypeValues.update("com.test.MyType");
        dataTypeValues.update("String");
        dataTypeValues.addCustomValue("com.test.YourType", "String");
        dataTypeValues.update("com.test.YourType");
        String nonCustomValue = dataTypeValues.getNonCustomValueForUserString("InvoiceLine");
        dataTypeValues.update(nonCustomValue);
        dataTypeValues.addCustomValue("com.test.HisType", "");
        dataTypeValues.update("com.test.HisType");
        Object[] acceptableValuesWithoutCustomValues = new String[]{"String", "Integer", "Boolean", "Float", "Object", "UserCommand [org.jbpm.examples.cmd]", "User [org.jbpm.examples.data]", "Invoice [org.kie.test]", "InvoiceLine [org.kie.test]", "PositionTest1 [org.kie.test]", "PositionTest2 [org.kie.test]", "PositionTest3 [org.kie.test]", "PositionTest5 [org.kie.test]", "SubComponent [org.kie.test]", "TestFormulas [org.kie.test]", "TestPatterns [org.kie.test]", "TestTypes [org.kie.test]", "TestTypesLine [org.kie.test]"};
        Object[] expectedAcceptableValuesWithCustomValues = new String[]{"", "com.test.HisType", "Edit com.test.HisType ...", "com.test.YourType", "com.test.MyType", "Custom ...", "Integer", "Boolean", "Float", "Object", "UserCommand [org.jbpm.examples.cmd]", "User [org.jbpm.examples.data]", "Invoice [org.kie.test]", "InvoiceLine [org.kie.test]", "PositionTest1 [org.kie.test]", "PositionTest2 [org.kie.test]", "PositionTest3 [org.kie.test]", "PositionTest5 [org.kie.test]", "SubComponent [org.kie.test]", "TestFormulas [org.kie.test]", "TestPatterns [org.kie.test]", "TestTypes [org.kie.test]", "TestTypesLine [org.kie.test]"};
        Assert.assertArrayEquals((Object[])acceptableValuesWithoutCustomValues, (Object[])dataTypeValues.getAcceptableValuesWithoutCustomValues().toArray());
        Assert.assertArrayEquals((Object[])expectedAcceptableValuesWithCustomValues, (Object[])dataTypeValues.getAcceptableValuesWithCustomValues().toArray());
    }
}

