/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jbpm.designer.client.popup.ActivityDataIOEditorView;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.util.ListBoxValues;

@Dependent
public class ActivityDataIOEditor
implements ActivityDataIOEditorView.Presenter {
    private boolean hasInputVars;
    private boolean isSingleInputVar;
    private boolean hasOutputVars;
    private boolean isSingleOutputVar;
    GetDataCallback callback = null;
    @Inject
    ActivityDataIOEditorView view;
    private List<String> dataTypes = new ArrayList<String>();
    private List<String> dataTypeDisplayNames = new ArrayList<String>();
    private AssignmentData assignmentData;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setCallback(GetDataCallback callback) {
        this.callback = callback;
    }

    @Override
    public void handleSaveClick() {
        if (this.callback != null) {
            AssignmentData data = new AssignmentData(this.view.getInputAssignmentData(), this.view.getOutputAssignmentData(), this.dataTypes, this.dataTypeDisplayNames);
            data.setVariableCountsString(this.hasInputVars, this.isSingleInputVar, this.hasOutputVars, this.isSingleOutputVar);
            String sData = this.marshallToJson(data);
            this.callback.getData(sData);
        }
        this.view.hideView();
    }

    protected String marshallToJson(AssignmentData data) {
        return Marshalling.toJSON((Object)data);
    }

    @Override
    public void handleCancelClick() {
        this.view.hideView();
    }

    public void setDataTypes(List<String> dataTypes, List<String> dataTypeDisplayNames) {
        this.dataTypes = dataTypes;
        this.dataTypeDisplayNames = dataTypeDisplayNames;
        this.view.setPossibleInputAssignmentsDataTypes(dataTypes, dataTypeDisplayNames);
        this.view.setPossibleOutputAssignmentsDataTypes(dataTypes, dataTypeDisplayNames);
    }

    public void setAssignmentData(AssignmentData assignmentData) {
        this.assignmentData = assignmentData;
    }

    public void configureDialog(String taskName, boolean hasInputVars, boolean isSingleInputVar, boolean hasOutputVars, boolean isSingleOutputVar) {
        this.hasInputVars = hasInputVars;
        this.isSingleInputVar = isSingleInputVar;
        this.hasOutputVars = hasOutputVars;
        this.isSingleOutputVar = isSingleOutputVar;
        if (taskName != null && !taskName.isEmpty()) {
            this.view.setCustomViewTitle(taskName);
        } else {
            this.view.setDefaultViewTitle();
        }
        this.view.setInputAssignmentsVisibility(hasInputVars);
        this.view.setOutputAssignmentsVisibility(hasOutputVars);
        this.view.setIsInputAssignmentSingleVar(isSingleInputVar);
        this.view.setIsOutputAssignmentSingleVar(isSingleOutputVar);
    }

    public void setDisallowedPropertyNames(List<String> disallowedPropertyNames) {
        HashSet<String> propertyNames = new HashSet<String>();
        if (disallowedPropertyNames != null) {
            for (String name : disallowedPropertyNames) {
                propertyNames.add(name.toLowerCase());
            }
        }
        this.view.setInputAssignmentsDisallowedNames(propertyNames);
    }

    public void setProcessVariables(List<String> processVariables) {
        this.view.setInputAssignmentsProcessVariables(processVariables);
        this.view.setOutputAssignmentsProcessVariables(processVariables);
    }

    public void setInputAssignmentRows(List<AssignmentRow> inputAssignmentRows) {
        this.view.setInputAssignmentRows(inputAssignmentRows);
    }

    public void setOutputAssignmentRows(List<AssignmentRow> outputAssignmentRows) {
        this.view.setOutputAssignmentRows(outputAssignmentRows);
    }

    public void show() {
        this.view.showView();
    }

    @Override
    public ListBoxValues.ValueTester dataTypesTester() {
        return new ListBoxValues.ValueTester(){

            @Override
            public String getNonCustomValueForUserString(String userValue) {
                if (ActivityDataIOEditor.this.assignmentData != null) {
                    return ActivityDataIOEditor.this.assignmentData.getDataTypeDisplayNameForUserString(userValue);
                }
                return null;
            }
        };
    }

    @Override
    public ListBoxValues.ValueTester processVarTester() {
        return new ListBoxValues.ValueTester(){

            @Override
            public String getNonCustomValueForUserString(String userValue) {
                return null;
            }
        };
    }

    public static interface GetDataCallback {
        public void getData(String var1);
    }
}

