/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.jbpm.designer.client.util.ComboBox;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.ComboBoxViewImpl;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ComboBoxAllTest {
    @Mock
    ComboBoxView.ModelPresenter modelPresenter;
    ComboBoxView view = new ComboBoxViewImpl();
    @Mock
    ValueListBox<String> listBox;
    String listBoxValue = "";
    boolean listBoxIsVisible = true;
    @Mock
    TextBox textBox;
    String textBoxValue = "";
    boolean textBoxIsVisible = false;
    @Spy
    ComboBox comboBox = new ComboBox();
    boolean quoteStringValues;
    String editPrefix;
    String editSuffix;
    String customPrompt;
    private final boolean processVarQuoteStringValues = true;
    private final String processVarConstantPrompt = "Constant ...";
    private final String processVarConstantPlaceholder = "Enter constant ...";
    private final String processVarEditPrefix = "Edit ";
    private final String processVarEditSuffix = " ...";
    List<String> processVarListBoxStartValues = Arrays.asList("** Variable Definitions **", "employee", "reason", "performance");
    private final boolean dataTypeQuoteStringValues = false;
    private final String dataTypeCustomPrompt = "Custom ...";
    private final String dataTypeCustomPlaceholder = "Enter type ...";
    private final String dataTypeEditPrefix = "Edit ";
    private final String dataTypeEditSuffix = " ...";
    List<String> dataTypeListBoxStartValues = Arrays.asList("String", "Integer", "Boolean", "Float", "Object", "Department [org.test.Department]", "Employee [org.test.Employee]", "Organization [org.test.Organization]");

    ListBoxValues getListBoxValues() {
        return this.comboBox.getListBoxValues();
    }

    private void initComboBoxTest(boolean quoteStringValues, String customPrompt, String placeholder, String editPrefix, String editSuffix, List<String> listBoxStartValues) {
        this.initPresenter();
        this.initListBox();
        this.initTextBox();
        ListBoxValues listBoxValues = new ListBoxValues(customPrompt, editPrefix, null);
        listBoxValues.addValues(listBoxStartValues);
        this.comboBox.view = this.view;
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, quoteStringValues, customPrompt, placeholder);
        this.comboBox.setListBoxValues(listBoxValues);
        this.comboBox.setShowCustomValues(true);
        this.quoteStringValues = quoteStringValues;
        this.editPrefix = editPrefix;
        this.editSuffix = editSuffix;
        this.customPrompt = customPrompt;
    }

    private void initPresenter() {
        ((ComboBoxView.ModelPresenter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String value = (String)invocation.getArguments()[1];
                ComboBoxAllTest.this.textBox.setValue((Object)value);
                return null;
            }
        }).when((Object)this.modelPresenter)).setTextBoxModelValue((TextBox)Mockito.any(TextBox.class), Mockito.anyString());
        ((ComboBoxView.ModelPresenter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String value = (String)invocation.getArguments()[1];
                ComboBoxAllTest.this.listBox.setValue((Object)value);
                return null;
            }
        }).when((Object)this.modelPresenter)).setListBoxModelValue((ValueListBox)Mockito.any(ValueListBox.class), Mockito.anyString());
        Mockito.when((Object)this.modelPresenter.getModelValue((ValueListBox)Mockito.any(ValueListBox.class))).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return ComboBoxAllTest.this.listBoxValue;
            }
        });
    }

    private void initListBox() {
        Mockito.when((Object)this.listBox.getValue()).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return ComboBoxAllTest.this.listBoxValue;
            }
        });
        ((ValueListBox)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ComboBoxAllTest.this.listBoxValue = (String)invocation.getArguments()[0];
                return null;
            }
        }).when(this.listBox)).setValue((Object)Mockito.anyString());
        Mockito.when((Object)this.listBox.isVisible()).thenAnswer((Answer)new Answer<Object>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return ComboBoxAllTest.this.listBoxIsVisible;
            }
        });
        ((ValueListBox)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ComboBoxAllTest.this.listBoxIsVisible = (Boolean)invocation.getArguments()[0];
                return null;
            }
        }).when(this.listBox)).setVisible(Mockito.anyBoolean());
    }

    private void initTextBox() {
        Mockito.when((Object)this.textBox.getValue()).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return ComboBoxAllTest.this.textBoxValue;
            }
        });
        ((TextBox)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ComboBoxAllTest.this.textBoxValue = (String)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)this.textBox)).setValue((Object)Mockito.anyString());
        Mockito.when((Object)this.textBox.isVisible()).thenAnswer((Answer)new Answer<Object>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return ComboBoxAllTest.this.textBoxIsVisible;
            }
        });
        ((TextBox)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ComboBoxAllTest.this.textBoxIsVisible = (Boolean)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)this.textBox)).setVisible(Mockito.anyBoolean());
    }

    @Test
    public void testProcessVarComboBox() {
        this.initComboBoxTest(true, "Constant ...", "Enter constant ...", "Edit ", " ...", this.processVarListBoxStartValues);
        this.setNonCustomValue(this.processVarListBoxStartValues.get(2), 1);
        String customStringValue1 = "first constant";
        this.setCustomValue(customStringValue1);
        this.setNonCustomValue(this.processVarListBoxStartValues.get(2), 2);
        String customNumericValue1 = "123";
        this.setCustomValue(customNumericValue1);
        this.setNonCustomValue(StringUtils.createQuotedConstant((String)customStringValue1), 2);
        String customNumericValue2 = "123.456";
        this.setCustomValue(customNumericValue2);
        this.aboutToEditCustomValue(customNumericValue2, 2);
        String customNumericValue3 = "100";
        this.editCustomValue(customNumericValue3);
        String customStringValue2 = "second constant";
        this.setCustomValue(customStringValue2);
        this.setNonCustomValue(StringUtils.createQuotedConstant((String)customStringValue1), 3);
        this.setNonCustomValue(this.processVarListBoxStartValues.get(2), 3);
        Assert.assertTrue((boolean)this.getListBoxValues().getAcceptableValuesWithCustomValues().contains(StringUtils.createQuotedConstant((String)customStringValue1)));
        Assert.assertTrue((boolean)this.getListBoxValues().getAcceptableValuesWithCustomValues().contains(customNumericValue1));
        Assert.assertTrue((!this.getListBoxValues().getAcceptableValuesWithCustomValues().contains(customNumericValue2) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getListBoxValues().getAcceptableValuesWithCustomValues().contains(customNumericValue3));
        Assert.assertTrue((boolean)this.getListBoxValues().getAcceptableValuesWithCustomValues().contains(StringUtils.createQuotedConstant((String)customStringValue2)));
    }

    @Test
    public void testDataTypeComboBox() {
        this.initComboBoxTest(false, "Custom ...", "Enter type ...", "Edit ", " ...", this.dataTypeListBoxStartValues);
        this.setNonCustomValue(this.dataTypeListBoxStartValues.get(2), 1);
        String customDataType1 = "com.acme.parts.Nut";
        this.setCustomValue(customDataType1);
        this.setNonCustomValue(this.dataTypeListBoxStartValues.get(6), 1);
        this.setNonCustomValue(customDataType1, 2);
        this.setNonCustomValue(this.dataTypeListBoxStartValues.get(5), 1);
        String customDataType2 = "com.acme.parts.Bolt";
        this.setCustomValue(customDataType2);
        this.setNonCustomValue(customDataType1, 3);
    }

    private void setCustomValue(String value) {
        this.comboBox.view.listBoxGotFocus();
        this.comboBox.listBoxValueChanged(this.customPrompt);
        Assert.assertEquals((Object)this.listBox.isVisible(), (Object)false);
        Assert.assertEquals((Object)this.textBox.isVisible(), (Object)true);
        this.comboBox.view.textBoxGotFocus();
        this.textBox.setValue((Object)value);
        this.comboBox.view.textBoxLostFocus();
        this.comboBox.view.listBoxGotFocus();
        Assert.assertEquals((Object)this.listBox.isVisible(), (Object)true);
        Assert.assertEquals((Object)this.textBox.isVisible(), (Object)false);
        String listBoxValue = this.quoteStringValues ? StringUtils.createQuotedConstant((String)value) : value;
        ((ComboBoxView.ModelPresenter)Mockito.verify((Object)this.modelPresenter)).setTextBoxModelValue(this.textBox, value);
        Assert.assertEquals((Object)this.comboBox.getValue(), (Object)listBoxValue);
    }

    private void setNonCustomValue(String value, int times) {
        this.comboBox.view.listBoxGotFocus();
        this.comboBox.listBoxValueChanged(value);
        Assert.assertEquals((Object)this.listBox.isVisible(), (Object)true);
        Assert.assertEquals((Object)this.textBox.isVisible(), (Object)false);
        ((ComboBoxView.ModelPresenter)Mockito.verify((Object)this.modelPresenter, (VerificationMode)Mockito.times((int)times))).setListBoxModelValue(this.listBox, value);
        Assert.assertEquals((Object)this.comboBox.getValue(), (Object)value);
    }

    private void aboutToEditCustomValue(String value, int times) {
        this.comboBox.view.listBoxGotFocus();
        this.comboBox.listBoxValueChanged(this.editPrefix + value + this.editSuffix);
        Assert.assertEquals((Object)this.listBox.isVisible(), (Object)false);
        Assert.assertEquals((Object)this.textBox.isVisible(), (Object)true);
        ((ComboBoxView.ModelPresenter)Mockito.verify((Object)this.modelPresenter, (VerificationMode)Mockito.times((int)times))).setTextBoxModelValue(this.textBox, value);
        Assert.assertEquals((Object)this.textBox.getValue(), (Object)value);
    }

    private void editCustomValue(String value) {
        this.comboBox.view.textBoxGotFocus();
        this.textBox.setValue((Object)value);
        this.comboBox.view.textBoxLostFocus();
        this.comboBox.view.listBoxGotFocus();
        Assert.assertEquals((Object)this.listBox.isVisible(), (Object)true);
        Assert.assertEquals((Object)this.textBox.isVisible(), (Object)false);
        String listBoxValue = this.quoteStringValues ? StringUtils.createQuotedConstant((String)value) : value;
        ((ComboBoxView.ModelPresenter)Mockito.verify((Object)this.modelPresenter)).setTextBoxModelValue(this.textBox, listBoxValue);
        Assert.assertEquals((Object)this.comboBox.getValue(), (Object)listBoxValue);
    }
}

