/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetView;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.util.ComboBox;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.DataIOEditorNameTextBox;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AssignmentListItemWidgetTest {
    ValueListBox<String> dataType;
    ValueListBox<String> processVar;
    TextBox customDataType;
    TextBox constant;
    ComboBox dataTypeComboBox;
    ComboBox processVarComboBox;
    @GwtMock
    DataIOEditorNameTextBox name;
    @GwtMock
    Button deleteButton;
    @GwtMock
    DataBinder<AssignmentRow> assignment;
    @Captor
    ArgumentCaptor<String> regExpCaptor;
    private AssignmentListItemWidgetViewImpl widget;

    @Before
    public void initTestCase() {
        GwtMockito.initMocks((Object)this);
        this.dataType = (ValueListBox)Mockito.mock(ValueListBox.class);
        this.processVar = (ValueListBox)Mockito.mock(ValueListBox.class);
        this.customDataType = (TextBox)Mockito.mock(TextBox.class);
        this.constant = (TextBox)Mockito.mock(TextBox.class);
        this.dataTypeComboBox = (ComboBox)Mockito.mock(ComboBox.class);
        this.processVarComboBox = (ComboBox)Mockito.mock(ComboBox.class);
        this.widget = (AssignmentListItemWidgetViewImpl)GWT.create(AssignmentListItemWidgetViewImpl.class);
        AssignmentRow assignmentRow = new AssignmentRow();
        this.widget.dataType = this.dataType;
        this.widget.customDataType = this.customDataType;
        this.widget.processVar = this.processVar;
        this.widget.constant = this.constant;
        this.widget.dataTypeComboBox = this.dataTypeComboBox;
        this.widget.name = this.name;
        this.widget.deleteButton = this.deleteButton;
        this.widget.processVarComboBox = this.processVarComboBox;
        this.widget.assignment = this.assignment;
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setTextBoxModelValue((TextBox)Mockito.any(TextBox.class), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setListBoxModelValue((ValueListBox)Mockito.any(ValueListBox.class), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).getModelValue((ValueListBox)Mockito.any(ValueListBox.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setDataType(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).getDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setCustomDataType(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).getCustomDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setConstant(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).getConstant();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setProcessVar(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).getProcessVar();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setDataTypes((ListBoxValues)Mockito.any(ListBoxValues.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setProcessVariables((ListBoxValues)Mockito.any(ListBoxValues.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).init();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.widget)).setModel((AssignmentRow)Mockito.any(AssignmentRow.class));
        Mockito.when((Object)this.widget.getModel()).thenReturn((Object)assignmentRow);
    }

    @Test
    public void testInitWidget() {
        this.widget.init();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).init();
        ((ComboBox)Mockito.verify((Object)this.dataTypeComboBox, (VerificationMode)Mockito.times((int)1))).init((ComboBoxView.ModelPresenter)this.widget, this.dataType, this.customDataType, false, AssignmentListItemWidgetView.CUSTOM_PROMPT, AssignmentListItemWidgetView.ENTER_TYPE_PROMPT);
        ((ComboBox)Mockito.verify((Object)this.processVarComboBox, (VerificationMode)Mockito.times((int)1))).init((ComboBoxView.ModelPresenter)this.widget, this.processVar, this.constant, true, AssignmentListItemWidgetView.CONSTANT_PROMPT, AssignmentListItemWidgetView.ENTER_CONSTANT_PROMPT);
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.name, (VerificationMode)Mockito.times((int)1))).setRegExp((String)this.regExpCaptor.capture(), Mockito.anyString(), Mockito.anyString());
        RegExp regExp = RegExp.compile((String)((String)this.regExpCaptor.getValue()));
        Assert.assertEquals((Object)false, (Object)regExp.test("a 1"));
        Assert.assertEquals((Object)false, (Object)regExp.test("a@1"));
        Assert.assertEquals((Object)true, (Object)regExp.test("a1"));
        ((TextBox)Mockito.verify((Object)this.customDataType, (VerificationMode)Mockito.times((int)1))).addKeyDownHandler((KeyDownHandler)Mockito.any(KeyDownHandler.class));
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.name, (VerificationMode)Mockito.times((int)1))).addBlurHandler((BlurHandler)Mockito.any(BlurHandler.class));
    }

    @Test
    public void testSetTextBoxModelValue() {
        this.widget.setTextBoxModelValue(this.customDataType, "abc");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).setCustomDataType("abc");
        this.widget.setTextBoxModelValue(this.constant, "abc");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).setConstant("abc");
    }

    @Test
    public void testSetListBoxModelValue() {
        this.widget.setListBoxModelValue(this.dataType, "abc");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).setDataType("abc");
        this.widget.setListBoxModelValue(this.processVar, "abc");
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).setProcessVar("abc");
    }

    @Test
    public void testSetModelInput() {
        Mockito.when((Object)this.widget.getVariableType()).thenReturn((Object)Variable.VariableType.INPUT);
        this.widget.setModel(new AssignmentRow());
        ((Button)Mockito.verify((Object)this.deleteButton)).setIcon(IconType.TRASH);
        ((TextBox)Mockito.verify((Object)this.constant, (VerificationMode)Mockito.never())).setVisible(Mockito.anyBoolean());
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getCustomDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getConstant();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getProcessVar();
    }

    @Test
    public void testSetModelOutput() {
        Mockito.when((Object)this.widget.getVariableType()).thenReturn((Object)Variable.VariableType.OUTPUT);
        this.widget.setModel(new AssignmentRow());
        ((Button)Mockito.verify((Object)this.deleteButton)).setIcon(IconType.TRASH);
        ((TextBox)Mockito.verify((Object)this.constant)).setVisible(false);
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getCustomDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getConstant();
        ((AssignmentListItemWidgetViewImpl)Mockito.verify((Object)this.widget)).getProcessVar();
    }

    @Test
    public void testQuotedConstant() {
        AssignmentRow row = new AssignmentRow();
        row.setConstant("abc");
        Mockito.when((Object)this.widget.getModel()).thenReturn((Object)row);
        this.widget.setModel(row);
        ((TextBox)Mockito.verify((Object)this.constant)).setValue((Object)"\"abc\"");
        ((ValueListBox)Mockito.verify(this.processVar)).setValue((Object)"\"abc\"");
    }

    @Test
    public void testSetGetCustomDataType() {
        String customDataType = "com.test.MyType";
        this.widget.setTextBoxModelValue(this.widget.customDataType, customDataType);
        String returnedCustomDataType1 = this.widget.getCustomDataType();
        Assert.assertEquals((Object)customDataType, (Object)returnedCustomDataType1);
        String returnedCustomDataType2 = this.widget.getModelValue(this.widget.dataType);
        Assert.assertEquals((Object)customDataType, (Object)returnedCustomDataType2);
    }

    @Test
    public void testSetGetDataType() {
        String sDataType = "Boolean";
        this.widget.setListBoxModelValue(this.widget.dataType, sDataType);
        String returnedDataType1 = this.widget.getDataType();
        Assert.assertEquals((Object)sDataType, (Object)returnedDataType1);
        String returnedDataType2 = this.widget.getModelValue(this.widget.dataType);
        Assert.assertEquals((Object)sDataType, (Object)returnedDataType2);
    }

    @Test
    public void testSetGetConstant() {
        String constant = "any constant";
        this.widget.setTextBoxModelValue(this.widget.constant, constant);
        String returnedConstant = this.widget.getConstant();
        Assert.assertEquals((Object)constant, (Object)returnedConstant);
        String returnedConstant2 = this.widget.getModelValue(this.widget.processVar);
        Assert.assertEquals((Object)constant, (Object)returnedConstant2);
    }

    @Test
    public void testSetGetProcessVar() {
        String sProcessVar = "username";
        this.widget.setListBoxModelValue(this.widget.processVar, sProcessVar);
        String returnedProcessVar1 = this.widget.getProcessVar();
        Assert.assertEquals((Object)sProcessVar, (Object)returnedProcessVar1);
        String returnedProcessVar2 = this.widget.getModelValue(this.widget.processVar);
        Assert.assertEquals((Object)sProcessVar, (Object)returnedProcessVar2);
    }

    @Test
    public void testSetDataTypes() {
        ListBoxValues dataTypeListBoxValues = new ListBoxValues(null, null, null);
        String sCustomType = "com.test.CustomType";
        this.widget.setCustomDataType(sCustomType);
        this.widget.setDataTypes(dataTypeListBoxValues);
        ((ComboBox)Mockito.verify((Object)this.dataTypeComboBox)).setListBoxValues(dataTypeListBoxValues);
        ((ComboBox)Mockito.verify((Object)this.dataTypeComboBox)).addCustomValueToListBoxValues(sCustomType, "");
    }

    @Test
    public void testSetProcessVariables() {
        ListBoxValues processVarListBoxValues = new ListBoxValues(null, null, null);
        String sConstant = "Mary Wilkins";
        this.widget.setConstant(sConstant);
        this.widget.setProcessVariables(processVarListBoxValues);
        ((ComboBox)Mockito.verify((Object)this.processVarComboBox)).setListBoxValues(processVarListBoxValues);
        ((ComboBox)Mockito.verify((Object)this.processVarComboBox)).addCustomValueToListBoxValues(sConstant, "");
    }
}

