/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.popup.ActivityDataIOEditorView;
import org.jbpm.designer.client.popup.ActivityDataIOEditorViewImpl;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityDataIOEditorViewImplTest {
    @Mock
    private ActivityDataIOEditorWidget inputAssignmentsWidget;
    @Mock
    private ActivityDataIOEditorWidget outputAssignmentsWidget;
    @Captor
    private ArgumentCaptor<List<AssignmentRow>> listAssignmentCaptor;
    @GwtMock
    private ActivityDataIOEditorViewImpl view;
    private List<AssignmentRow> rows;
    @Captor
    private ArgumentCaptor<ListBoxValues> valuesCaptor;
    private ActivityDataIOEditorView.Presenter presenter = new ActivityDataIOEditor();

    @Before
    public void setUp() {
        GwtMockito.initMocks((Object)this);
        this.view.inputAssignmentsWidget = this.inputAssignmentsWidget;
        this.view.outputAssignmentsWidget = this.outputAssignmentsWidget;
        this.view.presenter = this.presenter;
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setInputAssignmentRows((List)Mockito.any(List.class));
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setOutputAssignmentRows((List)Mockito.any(List.class));
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setPossibleInputAssignmentsDataTypes(Mockito.anyList());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setPossibleOutputAssignmentsDataTypes(Mockito.anyList());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setInputAssignmentsProcessVariables(Mockito.anyList());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setOutputAssignmentsProcessVariables(Mockito.anyList());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setInputAssignmentsDisallowedNames(Mockito.anySet());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setIsInputAssignmentSingleVar(Mockito.anyBoolean());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setIsOutputAssignmentSingleVar(Mockito.anyBoolean());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setInputAssignmentsVisibility(Mockito.anyBoolean());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setOutputAssignmentsVisibility(Mockito.anyBoolean());
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getInputAssignmentData();
        ((ActivityDataIOEditorViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getOutputAssignmentData();
        this.rows = new ArrayList<AssignmentRow>();
        this.rows.add(new AssignmentRow("varName", null, null, null, "varName", null));
        this.rows.add(new AssignmentRow("varName2", null, null, null, "varName2", null));
    }

    @Test
    public void testInputAssignmentsRowsSameSourceAndTargetName() {
        this.view.setInputAssignmentRows(this.rows);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.times((int)1))).setData((List)this.listAssignmentCaptor.capture());
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.never())).setData((List)Mockito.any(List.class));
        this.verifyForSameSourceAndTargetName();
    }

    @Test
    public void testOutputAssignmentsRowsSameSourceAndTargetName() {
        this.view.setOutputAssignmentRows(this.rows);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.times((int)1))).setData((List)this.listAssignmentCaptor.capture());
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.never())).setData((List)Mockito.any(List.class));
        this.verifyForSameSourceAndTargetName();
    }

    @Test
    public void testSetPossibleInputAssignmentsDataTypes() {
        List<String> dataTypes = Arrays.asList("String");
        this.view.setPossibleInputAssignmentsDataTypes(dataTypes);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setDataTypes((ListBoxValues)this.valuesCaptor.capture());
        List typesWithCustomValue = ((ListBoxValues)this.valuesCaptor.getValue()).getAcceptableValuesWithCustomValues();
        Assert.assertEquals((long)3L, (long)typesWithCustomValue.size());
        Assert.assertTrue((boolean)typesWithCustomValue.containsAll(Arrays.asList("", "Custom ...", "String")));
    }

    @Test
    public void testSetPossibleOutputAssignmentsDataTypes() {
        List<String> dataTypes = Arrays.asList("String");
        this.view.setPossibleOutputAssignmentsDataTypes(dataTypes);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setDataTypes((ListBoxValues)this.valuesCaptor.capture());
        List typesWithCustomValue = ((ListBoxValues)this.valuesCaptor.getValue()).getAcceptableValuesWithCustomValues();
        Assert.assertEquals((long)3L, (long)typesWithCustomValue.size());
        Assert.assertTrue((boolean)typesWithCustomValue.containsAll(Arrays.asList("", "Custom ...", "String")));
    }

    @Test
    public void testSetPossibleInputAssignmentsVariables() {
        List<String> variables = Arrays.asList("variable");
        this.view.setInputAssignmentsProcessVariables(variables);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setProcessVariables((ListBoxValues)this.valuesCaptor.capture());
        List variablesWithCustomValue = ((ListBoxValues)this.valuesCaptor.getValue()).getAcceptableValuesWithCustomValues();
        Assert.assertEquals((long)3L, (long)variablesWithCustomValue.size());
        Assert.assertTrue((boolean)variablesWithCustomValue.containsAll(Arrays.asList("", "Constant ...", "variable")));
    }

    @Test
    public void testSetPossibleOutputAssignmentsVariables() {
        List<String> variables = Arrays.asList("variable");
        this.view.setOutputAssignmentsProcessVariables(variables);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setProcessVariables((ListBoxValues)this.valuesCaptor.capture());
        List variablesWithCustomValue = ((ListBoxValues)this.valuesCaptor.getValue()).getAcceptableValuesWithCustomValues();
        Assert.assertEquals((long)3L, (long)variablesWithCustomValue.size());
        Assert.assertTrue((boolean)variablesWithCustomValue.containsAll(Arrays.asList("", "Constant ...", "variable")));
    }

    @Test
    public void testSetInputAssignmentsDisallowedNames() {
        HashSet<String> names = new HashSet<String>(Arrays.asList("nameA", "nameB"));
        this.view.setInputAssignmentsDisallowedNames(names);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setDisallowedNames(names, DesignerEditorConstants.INSTANCE.This_input_should_be_entered_as_a_property_for_the_task());
    }

    @Test
    public void testSetInputAssignmentsVisibility() {
        this.view.setInputAssignmentsVisibility(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsVisible(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.never())).setIsVisible(false);
        this.view.setInputAssignmentsVisibility(false);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsVisible(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsVisible(false);
    }

    @Test
    public void testSetOutputAssignmentsVisibility() {
        this.view.setOutputAssignmentsVisibility(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsVisible(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.never())).setIsVisible(false);
        this.view.setOutputAssignmentsVisibility(false);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsVisible(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsVisible(false);
    }

    @Test
    public void testSetInputAssignmentsSingleVar() {
        this.view.setIsInputAssignmentSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget, (VerificationMode)Mockito.never())).setIsSingleVar(false);
        this.view.setIsInputAssignmentSingleVar(false);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.inputAssignmentsWidget)).setIsSingleVar(false);
    }

    @Test
    public void testSetOutputAssignmentsSingleVar() {
        this.view.setIsOutputAssignmentSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget, (VerificationMode)Mockito.never())).setIsSingleVar(false);
        this.view.setIsOutputAssignmentSingleVar(false);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsSingleVar(true);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)this.outputAssignmentsWidget)).setIsSingleVar(false);
    }

    @Test
    public void testGetInputAssignemntsData() {
        Mockito.when((Object)this.inputAssignmentsWidget.getData()).thenReturn(this.rows);
        Assert.assertEquals(this.rows, (Object)this.view.getInputAssignmentData());
    }

    @Test
    public void testGetOutputAssignemntsData() {
        Mockito.when((Object)this.outputAssignmentsWidget.getData()).thenReturn(this.rows);
        Assert.assertEquals(this.rows, (Object)this.view.getOutputAssignmentData());
    }

    private void verifyForSameSourceAndTargetName() {
        Assert.assertEquals((long)2L, (long)((List)this.listAssignmentCaptor.getValue()).size());
        Assert.assertEquals((Object)this.rows.get(0), ((List)this.listAssignmentCaptor.getValue()).get(0));
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(0)).getProcessVar());
        Assert.assertEquals((Object)this.rows.get(1), ((List)this.listAssignmentCaptor.getValue()).get(1));
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.listAssignmentCaptor.getValue()).get(1)).getProcessVar());
    }
}

