/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.util.ComboBox;
import org.jbpm.designer.client.util.DataIOEditorNameTextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class AssignmentListItemWidgetViewImplTest {
    private static final String VARIABLE_NAME = "variableName";
    private static final String CONSTANT_NAME = "constantName";
    private static final String CUST_DATA_TYPE_NAME = "custDataTypeName";
    private static final String DATA_TYPE_NAME = "dataTypeName";
    @GwtMock
    private DataBinder<AssignmentRow> assignment;
    @GwtMock
    private DataIOEditorNameTextBox name;
    @GwtMock
    private Button deleteButton;
    private TextBox customDataType;
    private TextBox constant;
    private ValueListBox<String> dataType;
    private ValueListBox<String> processVar;
    private ComboBox dataTypeComboBox;
    private ComboBox processVarComboBox;
    @GwtMock
    private KeyDownEvent keyDownEvent;
    private Event<NotificationEvent> notification = (Event)Mockito.mock(EventSourceMock.class);
    @Captor
    private ArgumentCaptor<KeyDownHandler> keyDownHandlerCaptor;
    @Captor
    private ArgumentCaptor<BlurHandler> blurHandlerCaptor;
    private AssignmentListItemWidgetViewImpl view;

    @Before
    public void setUp() throws Exception {
        GwtMockito.initMocks((Object)this);
        this.customDataType = (TextBox)Mockito.mock(TextBox.class);
        this.constant = (TextBox)Mockito.mock(TextBox.class);
        this.dataType = (ValueListBox)Mockito.mock(ValueListBox.class);
        this.processVar = (ValueListBox)Mockito.mock(ValueListBox.class);
        this.dataTypeComboBox = (ComboBox)Mockito.mock(ComboBox.class);
        this.processVarComboBox = (ComboBox)Mockito.mock(ComboBox.class);
        this.view = (AssignmentListItemWidgetViewImpl)Mockito.mock(AssignmentListItemWidgetViewImpl.class);
        this.view.assignment = this.assignment;
        this.view.name = this.name;
        this.view.deleteButton = this.deleteButton;
        this.view.customDataType = this.customDataType;
        this.view.dataType = this.dataType;
        this.view.constant = this.constant;
        this.view.processVar = this.processVar;
        this.view.dataTypeComboBox = this.dataTypeComboBox;
        this.view.processVarComboBox = this.processVarComboBox;
        this.view.notification = this.notification;
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).init();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getConstant();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setConstant(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getCustomDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setCustomDataType(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getModel();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setModel((AssignmentRow)Mockito.any(AssignmentRow.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getModelValue((ValueListBox)Mockito.any(ValueListBox.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setTextBoxModelValue((TextBox)Mockito.any(TextBox.class), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setListBoxModelValue((ValueListBox)Mockito.any(ValueListBox.class), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getDataType();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setDataType(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getProcessVar();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setProcessVar(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getVariableType();
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setAllowDuplicateNames(Mockito.anyBoolean(), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setParentWidget((ActivityDataIOEditorWidget)Mockito.any(ActivityDataIOEditorWidget.class));
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).isDuplicateName(Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setShowConstants(Mockito.anyBoolean());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setDisallowedNames(Mockito.anySet(), Mockito.anyString());
        ((AssignmentListItemWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).handleDeleteButton((ClickEvent)Mockito.any(ClickEvent.class));
        AssignmentRow row = new AssignmentRow();
        ((DataBinder)Mockito.doReturn((Object)row).when(this.assignment)).getModel();
    }

    @Test
    public void testSetModelInputCustomProcessVar() {
        AssignmentRow row = new AssignmentRow();
        row.setProcessVar(VARIABLE_NAME);
        row.setConstant(null);
        row.setName(VARIABLE_NAME);
        row.setCustomDataType(CUST_DATA_TYPE_NAME);
        row.setDataType(null);
        row.setVariableType(Variable.VariableType.INPUT);
        ((DataBinder)Mockito.doReturn((Object)row).when(this.assignment)).getModel();
        this.view.setModel(row);
        ((DataBinder)Mockito.verify(this.assignment, (VerificationMode)Mockito.times((int)1))).setModel((Object)row);
        ((Button)Mockito.verify((Object)this.deleteButton, (VerificationMode)Mockito.times((int)1))).setIcon(IconType.TRASH);
        ((TextBox)Mockito.verify((Object)this.constant, (VerificationMode)Mockito.never())).setVisible(false);
        ((TextBox)Mockito.verify((Object)this.customDataType, (VerificationMode)Mockito.times((int)1))).setValue((Object)CUST_DATA_TYPE_NAME);
        ((ValueListBox)Mockito.verify(this.dataType, (VerificationMode)Mockito.times((int)1))).setValue((Object)CUST_DATA_TYPE_NAME);
        ((ValueListBox)Mockito.verify(this.processVar, (VerificationMode)Mockito.times((int)1))).setValue((Object)VARIABLE_NAME);
        ((TextBox)Mockito.verify((Object)this.constant, (VerificationMode)Mockito.never())).setValue((Object)Mockito.anyString());
    }

    @Test
    public void testSetModelOutputNormalConstant() {
        AssignmentRow row = new AssignmentRow();
        row.setProcessVar(null);
        row.setConstant(CONSTANT_NAME);
        row.setName(VARIABLE_NAME);
        row.setCustomDataType(null);
        row.setDataType(DATA_TYPE_NAME);
        row.setVariableType(Variable.VariableType.OUTPUT);
        ((DataBinder)Mockito.doReturn((Object)row).when(this.assignment)).getModel();
        this.view.setModel(row);
        ((DataBinder)Mockito.verify(this.assignment, (VerificationMode)Mockito.times((int)1))).setModel((Object)row);
        ((Button)Mockito.verify((Object)this.deleteButton, (VerificationMode)Mockito.times((int)1))).setIcon(IconType.TRASH);
        ((TextBox)Mockito.verify((Object)this.constant, (VerificationMode)Mockito.times((int)1))).setVisible(false);
        ((TextBox)Mockito.verify((Object)this.customDataType, (VerificationMode)Mockito.never())).setValue((Object)DATA_TYPE_NAME);
        ((ValueListBox)Mockito.verify(this.dataType, (VerificationMode)Mockito.times((int)1))).setValue((Object)DATA_TYPE_NAME);
        ((TextBox)Mockito.verify((Object)this.constant, (VerificationMode)Mockito.times((int)1))).setValue((Object)CONSTANT_NAME);
    }

    @Test
    public void testSetTextBoxModelValueCustomDataType() {
        Assert.assertNull((Object)this.view.getModel().getCustomDataType());
        this.view.setTextBoxModelValue(this.customDataType, "abc");
        Assert.assertEquals((Object)"abc", (Object)this.view.getModel().getCustomDataType());
        Assert.assertNull((Object)this.view.getModel().getConstant());
        Assert.assertEquals((Object)"abc", (Object)this.view.getModelValue(this.dataType));
    }

    @Test
    public void testSetTextBoxModelValueConstant() {
        Assert.assertNull((Object)this.view.getModel().getConstant());
        this.view.setTextBoxModelValue(this.constant, "abc");
        Assert.assertEquals((Object)"abc", (Object)this.view.getModel().getConstant());
        Assert.assertNull((Object)this.view.getModel().getCustomDataType());
        Assert.assertEquals((Object)"abc", (Object)this.view.getModelValue(this.processVar));
    }

    @Test
    public void testSetListBoxModelValueDataType() {
        Assert.assertNull((Object)this.view.getModel().getDataType());
        this.view.setListBoxModelValue(this.dataType, "abc");
        Assert.assertEquals((Object)"abc", (Object)this.view.getModel().getDataType());
        Assert.assertNull((Object)this.view.getModel().getCustomDataType());
        Assert.assertNull((Object)this.view.getModel().getProcessVar());
        Assert.assertEquals((Object)"abc", (Object)this.view.getModelValue(this.dataType));
    }

    @Test
    public void testSetListBoxModelValueProcessVar() {
        Assert.assertNull((Object)this.view.getModel().getProcessVar());
        this.view.setListBoxModelValue(this.processVar, "abc");
        Assert.assertEquals((Object)"abc", (Object)this.view.getModel().getProcessVar());
        Assert.assertNull((Object)this.view.getModel().getConstant());
        Assert.assertNull((Object)this.view.getModel().getDataType());
        Assert.assertEquals((Object)"abc", (Object)this.view.getModelValue(this.processVar));
    }

    @Test
    public void testDataTypeHandlerSpace() {
        this.view.init();
        ((TextBox)Mockito.verify((Object)this.customDataType, (VerificationMode)Mockito.times((int)1))).addKeyDownHandler((KeyDownHandler)this.keyDownHandlerCaptor.capture());
        KeyDownHandler handler = (KeyDownHandler)this.keyDownHandlerCaptor.getValue();
        ((KeyDownEvent)Mockito.doReturn((Object)32).when((Object)this.keyDownEvent)).getNativeKeyCode();
        handler.onKeyDown(this.keyDownEvent);
        ((KeyDownEvent)Mockito.verify((Object)this.keyDownEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
    }

    @Test
    public void testDataTypeHandlerAlphabetical() {
        this.view.init();
        ((TextBox)Mockito.verify((Object)this.customDataType, (VerificationMode)Mockito.times((int)1))).addKeyDownHandler((KeyDownHandler)this.keyDownHandlerCaptor.capture());
        KeyDownHandler handler = (KeyDownHandler)this.keyDownHandlerCaptor.getValue();
        ((KeyDownEvent)Mockito.doReturn((Object)97).when((Object)this.keyDownEvent)).getNativeKeyCode();
        handler.onKeyDown(this.keyDownEvent);
        ((KeyDownEvent)Mockito.verify((Object)this.keyDownEvent, (VerificationMode)Mockito.never())).preventDefault();
    }

    @Test
    public void testNameBlurHandler() {
        ActivityDataIOEditorWidget parent = (ActivityDataIOEditorWidget)Mockito.mock(ActivityDataIOEditorWidget.class);
        Mockito.when((Object)parent.isDuplicateName(Mockito.anyString())).thenReturn((Object)true);
        ((DataIOEditorNameTextBox)Mockito.doReturn((Object)"anyName").when((Object)this.name)).getText();
        this.view.setAllowDuplicateNames(false, "ErrorMessage");
        this.view.setParentWidget(parent);
        this.view.init();
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.name, (VerificationMode)Mockito.times((int)1))).addBlurHandler((BlurHandler)this.blurHandlerCaptor.capture());
        BlurHandler handler = (BlurHandler)this.blurHandlerCaptor.getValue();
        handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)parent, (VerificationMode)Mockito.times((int)1))).isDuplicateName("anyName");
        ((Event)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("ErrorMessage", NotificationEvent.NotificationType.ERROR));
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.name, (VerificationMode)Mockito.times((int)1))).setValue((Object)"");
    }

    @Test
    public void testSetShowConstantsTrue() {
        this.view.setShowConstants(true);
        ((ComboBox)Mockito.verify((Object)this.processVarComboBox)).setShowCustomValues(true);
    }

    @Test
    public void testSetShowConstantsFalse() {
        this.view.setShowConstants(false);
        ((ComboBox)Mockito.verify((Object)this.processVarComboBox)).setShowCustomValues(false);
    }

    @Test
    public void testSetDisallowedNames() {
        HashSet disallowedNames = new HashSet();
        String disallowedNameErrorMessage = "error value";
        this.view.setDisallowedNames(disallowedNames, disallowedNameErrorMessage);
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.name)).setInvalidValues(disallowedNames, false, disallowedNameErrorMessage);
    }

    @Test
    public void testHandleDeleteButton() {
        ActivityDataIOEditorWidget widget = (ActivityDataIOEditorWidget)Mockito.mock(ActivityDataIOEditorWidget.class);
        AssignmentRow model = (AssignmentRow)Mockito.mock(AssignmentRow.class);
        Mockito.when((Object)this.view.getModel()).thenReturn((Object)model);
        this.view.setParentWidget(widget);
        this.view.handleDeleteButton(null);
        ((ActivityDataIOEditorWidget)Mockito.verify((Object)widget)).removeAssignment(model);
    }
}

