/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.widget.ListWidget;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetView;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetViewImpl;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityDataIOEditorWidgetViewImplTest {
    @Mock
    ActivityDataIOEditorWidgetView.Presenter presenter;
    @GwtMock
    private Button button;
    @Mock
    private TableCellElement nameth;
    @Mock
    private TableCellElement datatypeth;
    @GwtMock
    private ListWidget<AssignmentRow, AssignmentListItemWidgetViewImpl> assignments;
    private ActivityDataIOEditorWidgetViewImpl view;
    @Captor
    private ArgumentCaptor<List<AssignmentRow>> captor;
    @Captor
    private ArgumentCaptor<NotificationEvent> eventCaptor;
    private List<AssignmentRow> rows;
    protected Event<NotificationEvent> notification = (Event)Mockito.mock(EventSourceMock.class);

    @Before
    public void setUp() {
        GwtMockito.initMocks((Object)this);
        this.view = (ActivityDataIOEditorWidgetViewImpl)GWT.create(ActivityDataIOEditorWidgetViewImpl.class);
        this.view.assignments = this.assignments;
        this.view.addVarButton = this.button;
        this.view.nameth = this.nameth;
        this.view.datatypeth = this.datatypeth;
        this.view.notification = this.notification;
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setAssignmentRows((List)Mockito.any(List.class));
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).init((ActivityDataIOEditorWidgetView.Presenter)Mockito.any(ActivityDataIOEditorWidgetView.Presenter.class));
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).handleAddVarButton((ClickEvent)Mockito.any(ClickEvent.class));
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).showOnlySingleEntryAllowed();
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getAssignmentRows();
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getAssignmentWidget(Mockito.anyInt());
        ((ActivityDataIOEditorWidgetViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).getAssignmentsCount();
        this.rows = new ArrayList<AssignmentRow>();
        this.rows.add(new AssignmentRow("varName", null, null, null, "varName", null));
        this.rows.add(new AssignmentRow("varName2", null, null, null, "varName2", null));
    }

    @Test
    public void testInit() {
        this.view.init(this.presenter);
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.times((int)1))).setText(DesignerEditorConstants.INSTANCE.Add());
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.times((int)1))).setIcon(IconType.PLUS);
    }

    @Test
    public void testHandleAddVarButton() {
        this.view.init(this.presenter);
        this.view.handleAddVarButton((ClickEvent)Mockito.mock(ClickEvent.class));
        ((ActivityDataIOEditorWidgetView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).handleAddClick();
    }

    @Test
    public void testAssignmentsRowsSameSourceAndTarget() {
        this.view.setAssignmentRows(this.rows);
        ((ListWidget)Mockito.verify(this.assignments, (VerificationMode)Mockito.times((int)1))).setValue((List)this.captor.capture());
        Assert.assertEquals((long)2L, (long)((List)this.captor.getValue()).size());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)"varName", (Object)((AssignmentRow)((List)this.captor.getValue()).get(0)).getProcessVar());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.captor.getValue()).get(1)).getName());
        Assert.assertEquals((Object)"varName2", (Object)((AssignmentRow)((List)this.captor.getValue()).get(1)).getProcessVar());
    }

    @Test
    public void testOnlySingleEntryAllowed() {
        this.view.showOnlySingleEntryAllowed();
        ((Event)Mockito.verify(this.notification)).fire(this.eventCaptor.capture());
        Assert.assertEquals((Object)DesignerEditorConstants.INSTANCE.Only_single_entry_allowed(), (Object)((NotificationEvent)this.eventCaptor.getValue()).getNotification());
    }

    @Test
    public void testGetAssignmentRows() {
        Mockito.when((Object)this.assignments.getValue()).thenReturn(this.rows);
        Assert.assertEquals(this.rows, (Object)this.view.getAssignmentRows());
    }

    @Test
    public void testGetAssignmentsCountEmpty() {
        Mockito.when((Object)this.assignments.getValue()).thenReturn(new ArrayList());
        Assert.assertEquals((long)0L, (long)this.view.getAssignmentsCount());
    }

    @Test
    public void testGetAssignmentsCount() {
        Mockito.when((Object)this.assignments.getValue()).thenReturn(this.rows);
        Assert.assertEquals((long)2L, (long)this.view.getAssignmentsCount());
    }

    @Test
    public void testGetAssignmentWidget() {
        this.view.getAssignmentWidget(0);
        ((ListWidget)Mockito.verify(this.assignments)).getComponent(0);
    }

    @Test
    public void testGetAssignmentWidgetMoreComplex() {
        this.view.getAssignmentWidget(123);
        ((ListWidget)Mockito.verify(this.assignments)).getComponent(123);
    }
}

