/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.jbpm.designer.client.util.ComboBox;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.ListBoxValues;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ComboBoxTest {
    @Mock
    ComboBoxView.ModelPresenter modelPresenter;
    @Mock
    ComboBoxView view;
    @Mock
    ListBoxValues listBoxValues;
    @Mock
    ValueListBox<String> listBox;
    @Mock
    TextBox textBox;
    @Spy
    @InjectMocks
    ComboBox comboBox = new ComboBox();
    private final boolean processVarQuoteStringValues = true;
    private final String processVarConstantPrompt = "Constant ...";
    private final String processVarConstantPlaceholder = "Enter constant ...";
    private final String processVarEditPrefix = "Edit ";
    private final String processVarEditSuffix = " ...";

    @Before
    public void initMocks() {
        Mockito.when((Object)this.listBoxValues.getEditPrefix()).thenReturn((Object)"Edit ");
    }

    @Test
    public void testInit() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        ((ComboBoxView)Mockito.verify((Object)this.view)).init((ComboBoxView.ComboBoxPresenter)this.comboBox, this.modelPresenter, this.listBox, this.textBox, "Enter constant ...");
    }

    @Test
    public void testUpdateListBoxValues_Custom() {
        this.comboBox.setShowCustomValues(true);
        String customValue = "a custom value";
        this.comboBox.updateListBoxValues(customValue);
        ((ListBoxValues)Mockito.verify((Object)this.listBoxValues)).update(customValue);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setAcceptableValues((List)Mockito.any(List.class));
    }

    @Test
    public void testUpdateListBoxValues_NonCustom() {
        this.comboBox.setShowCustomValues(false);
        String customValue = "a custom value";
        this.comboBox.updateListBoxValues(customValue);
        ((ListBoxValues)Mockito.verify((Object)this.listBoxValues)).getAcceptableValuesWithoutCustomValues();
        ((ComboBoxView)Mockito.verify((Object)this.view)).setAcceptableValues((List)Mockito.any(List.class));
    }

    @Test
    public void testListBoxValueChanged_CustomPrompt() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        this.comboBox.listBoxValueChanged("Constant ...");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(true);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxFocus(true);
    }

    @Test
    public void testListBoxValueChanged_InvalidValue() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        this.comboBox.listBoxValueChanged("********");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
    }

    @Test
    public void testListBoxValueChanged_EditValueString() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "a constant";
        Mockito.when((Object)this.view.getModelValue()).thenReturn((Object)constant);
        this.comboBox.listBoxValueChanged("Edit \"" + constant + "\"" + " ...");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(true);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxFocus(true);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setListBoxValue(Mockito.anyString());
    }

    @Test
    public void testListBoxValueChanged_EditValueNumber() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "123";
        Mockito.when((Object)this.view.getModelValue()).thenReturn((Object)constant);
        this.comboBox.listBoxValueChanged("Edit " + constant + " ...");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(true);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxFocus(true);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setListBoxValue(Mockito.anyString());
    }

    @Test
    public void testListBoxValueChanged_CustomValueString() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "a constant";
        String quotedConstant = StringUtils.createQuotedConstant((String)constant);
        Mockito.when((Object)this.listBoxValues.isCustomValue(quotedConstant)).thenReturn((Object)true);
        Mockito.when((Object)this.listBoxValues.getValueForDisplayValue(quotedConstant)).thenReturn((Object)quotedConstant);
        this.comboBox.listBoxValueChanged(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue(constant);
    }

    @Test
    public void testListBoxValueChanged_CustomValueQString1() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "\"hello\"";
        String quotedConstant = StringUtils.createQuotedConstant((String)constant);
        Mockito.when((Object)this.listBoxValues.isCustomValue(quotedConstant)).thenReturn((Object)true);
        Mockito.when((Object)this.listBoxValues.getValueForDisplayValue(quotedConstant)).thenReturn((Object)quotedConstant);
        this.comboBox.listBoxValueChanged(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue(constant);
    }

    @Test
    public void testListBoxValueChanged_CustomValueQString2() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "greeting={\"hello\"}";
        String quotedConstant = StringUtils.createQuotedConstant((String)constant);
        Mockito.when((Object)this.listBoxValues.isCustomValue(quotedConstant)).thenReturn((Object)true);
        Mockito.when((Object)this.listBoxValues.getValueForDisplayValue(quotedConstant)).thenReturn((Object)quotedConstant);
        this.comboBox.listBoxValueChanged(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(quotedConstant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue(constant);
    }

    @Test
    public void testListBoxValueChanged_CustomValueNumber() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String constant = "123";
        Mockito.when((Object)this.listBoxValues.isCustomValue(constant)).thenReturn((Object)true);
        Mockito.when((Object)this.listBoxValues.getValueForDisplayValue(constant)).thenReturn((Object)constant);
        this.comboBox.listBoxValueChanged(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(constant);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue(constant);
    }

    @Test
    public void testListBoxValueChanged_ExistingValueString() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String value = "employee";
        Mockito.when((Object)this.listBoxValues.isCustomValue(value)).thenReturn((Object)false);
        this.comboBox.listBoxValueChanged(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
    }

    @Test
    public void testListBoxValueChanged_ExistingValueNumber() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String value = "123";
        Mockito.when((Object)this.listBoxValues.isCustomValue(value)).thenReturn((Object)false);
        this.comboBox.listBoxValueChanged(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
    }

    @Test
    public void testTextBoxValueChanged_Empty() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        this.comboBox.textBoxValueChanged("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(true);
    }

    @Test
    public void testTextBoxValueChanged_NonCustomValue() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String value = "employee";
        Mockito.when((Object)this.listBoxValues.getNonCustomValueForUserString(value)).thenReturn((Object)value);
        this.comboBox.textBoxValueChanged(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue("");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(true);
    }

    @Test
    public void testTextBoxValueChanged_CustomValue() {
        this.comboBox.init(this.modelPresenter, this.listBox, this.textBox, true, "Constant ...", "Enter constant ...");
        String value = "something new";
        String quotedValue = StringUtils.createQuotedConstant((String)value);
        Mockito.when((Object)this.listBoxValues.getNonCustomValueForUserString(value)).thenReturn(null);
        Mockito.when((Object)this.comboBox.addCustomValueToListBoxValues(value, "")).thenReturn((Object)quotedValue);
        this.comboBox.textBoxValueChanged(value);
        ((ComboBox)Mockito.verify((Object)this.comboBox, (VerificationMode)Mockito.times((int)2))).addCustomValueToListBoxValues(value, "");
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxValue(quotedValue);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxModelValue(quotedValue);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxModelValue(value);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setTextBoxVisible(false);
        ((ComboBoxView)Mockito.verify((Object)this.view)).setListBoxVisible(true);
    }
}

