/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import java.util.List;
import java.util.Map;
import org.jbpm.designer.client.shared.AssignmentBaseTest;
import org.jbpm.designer.client.shared.AssignmentData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AssignmentDataTest
extends AssignmentBaseTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testSetVariableCountsString1() {
        AssignmentData assignmentData = new AssignmentData("inStr:String", null, "str1:String", "[din]str1->inStr", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, true, false, false);
        Assert.assertEquals((Object)"1 Data_Input", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString2() {
        AssignmentData assignmentData = new AssignmentData("", null, "str1:String", null, "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, true, false, false);
        Assert.assertEquals((Object)"No_Data_Input", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString3() {
        AssignmentData assignmentData = new AssignmentData(null, "outStr1:String", "str1:String,int1:Integer,custom1:org.jdl.Custom", "[dout]outStr1->str1", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(false, false, true, true);
        Assert.assertEquals((Object)"1 Data_Output", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString4() {
        AssignmentData assignmentData = new AssignmentData(null, null, "str1:String,int1:Integer,custom1:org.jdl.Custom", null, "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(false, false, true, true);
        Assert.assertEquals((Object)"No_Data_Output", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString5() {
        AssignmentData assignmentData = new AssignmentData(null, null, "str1:String,int1:Integer,custom1:org.jdl.Custom", null, "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, false, true, false);
        Assert.assertEquals((Object)"0 Data_Inputs, 0 Data_Outputs", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString6() {
        AssignmentData assignmentData = new AssignmentData("inStr:String,Skippable", "outStr1:String", "str1:String,int1:Integer,custom1:org.jdl.Custom", "[din]str1->inStr,[dout]outStr1->str1", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, false, true, false);
        Assert.assertEquals((Object)"1 Data_Input, 1 Data_Output", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString10() {
        AssignmentData assignmentData = new AssignmentData("inStr:String,inInt1:Integer,inCustom1:org.jdl.Custom,inStrConst:String,Skippable", "outStr1:String,outInt1:Integer,outCustom1:org.jdl.Custom", "str1:String,int1:Integer,custom1:org.jdl.Custom", "[din]str1->inStr,[din]int1->inInt1,[din]custom1->inCustom1,[din]inStrConst=TheString,[dout]outStr1->str1,[dout]outInt1->int1,[dout]outCustom1->custom1", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, false, true, false);
        Assert.assertEquals((Object)"4 Data_Inputs, 3 Data_Outputs", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetVariableCountsString11() {
        AssignmentData assignmentData = new AssignmentData(null, "outStr1:String", "str1:String,int1:Integer,custom1:org.jdl.Custom", "[dout]outStr1->str1,[dout]outStr1->int1,[dout]outStr1->custom1", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", null);
        assignmentData.setVariableCountsString(true, false, true, false);
        Assert.assertEquals((Object)"0 Data_Inputs, 3 Data_Outputs", (Object)assignmentData.getVariableCountsString());
    }

    @Test
    public void testSetCustomAssignmentProperties() {
        AssignmentData assignmentData = new AssignmentData(null, "outStr1:String", "str1:String,int1:Integer,custom1:org.jdl.Custom", "[dout]outStr1->str1,[dout]outStr1->int1,[dout]outStr1->custom1", "String:String, Integer:Integer, Boolean:Boolean, Float:Float, Object:Object", "GroupId,Skippable,Comment,Description,Priority,Content,TaskName,Locale,CreatedBy,NotCompletedReassign,NotStartedReassign,NotCompletedNotify,NotStartedNotify", "FaultToUri:Henry;Rod;Tony;,TruckType:Mazda;Tonka;Mercedes;,FromUri:,ReplyToUri:Jane;,");
        Map customAssignmentProperties = assignmentData.getCustomAssignmentProperties();
        Assert.assertTrue((boolean)customAssignmentProperties.containsKey("FaultToUri"));
        Assert.assertTrue((boolean)customAssignmentProperties.containsKey("TruckType"));
        Assert.assertTrue((boolean)customAssignmentProperties.containsKey("FromUri"));
        Assert.assertTrue((boolean)customAssignmentProperties.containsKey("ReplyToUri"));
        List truckTypeValues = (List)customAssignmentProperties.get("TruckType");
        Assert.assertNotNull((Object)truckTypeValues);
        Assert.assertEquals((long)3L, (long)truckTypeValues.size());
        Assert.assertTrue((boolean)truckTypeValues.contains("Mazda"));
        Assert.assertTrue((boolean)truckTypeValues.contains("Tonka"));
        Assert.assertTrue((boolean)truckTypeValues.contains("Mercedes"));
        List replyToUriValues = (List)customAssignmentProperties.get("ReplyToUri");
        Assert.assertNotNull((Object)replyToUriValues);
        Assert.assertEquals((long)1L, (long)replyToUriValues.size());
        Assert.assertTrue((boolean)replyToUriValues.contains("Jane"));
        List fromUriValues = (List)customAssignmentProperties.get("FromUri");
        Assert.assertNotNull((Object)fromUriValues);
        Assert.assertTrue((boolean)fromUriValues.isEmpty());
        String customAssignmentPropertiesString = assignmentData.getCustomAssignmentPropertiesString();
        Assert.assertEquals((Object)"TruckType:Mazda;Tonka;Mercedes;,FromUri:,FaultToUri:Henry;Rod;Tony;,ReplyToUri:Jane;,", (Object)customAssignmentPropertiesString);
    }
}

