/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import com.google.common.collect.Iterables;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jbpm.designer.client.DesignerPopUpPresenter;
import org.jbpm.designer.client.DesignerViewImpl;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.jbpm.designer.client.DesignerWidgetView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class OnResizeTest {
    private DesignerWidgetView designerWidgetView;
    @Spy
    private DesignerPopUpPresenter designerPopupPresenter;
    @Spy
    private DesignerViewImpl designerViewImpl;
    @GwtMock
    Widget parentWidget;
    @GwtMock
    Frame inlineFrame;
    @GwtMock
    FlowPanel parentContaner;
    @GwtMock
    DesignerWidgetPresenter designerWidgetPresenter;

    @Before
    public void setup() {
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.inlineFrame.getElement()).thenReturn((Object)element);
        Mockito.when((Object)element.getStyle()).thenReturn((Object)((Style)Mockito.mock(Style.class)));
        this.designerWidgetView = (DesignerWidgetView)Mockito.spy((Object)new DesignerWidgetView());
    }

    @Test
    public void testDesignerWidgetViewOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerWidgetView.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor captorHeight = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor captorWidth = ArgumentCaptor.forClass(String.class);
        this.designerWidgetView.onResize();
        ((DesignerWidgetView)Mockito.verify((Object)this.designerWidgetView)).setPixelSize(((Integer)pixelSizeCaptorWidth.capture()).intValue(), ((Integer)pixelSizeCaptorHeight.capture()).intValue());
        ((Frame)Mockito.verify((Object)this.inlineFrame, (VerificationMode)Mockito.times((int)2))).setHeight((String)captorHeight.capture());
        ((Frame)Mockito.verify((Object)this.inlineFrame, (VerificationMode)Mockito.times((int)2))).setWidth((String)captorWidth.capture());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorWidth.getValue()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorHeight.getValue()).intValue());
        Assert.assertEquals((Object)"95px", (Object)Iterables.getLast((Iterable)captorHeight.getAllValues()));
        Assert.assertEquals((Object)"100%", (Object)Iterables.getLast((Iterable)captorWidth.getAllValues()));
    }

    @Test
    public void testDesignerPopupPresenterOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerPopupPresenter.getContainer()).thenReturn((Object)this.parentContaner);
        Mockito.when((Object)this.parentContaner.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(String.class);
        this.designerPopupPresenter.onResize();
        ((FlowPanel)Mockito.verify((Object)this.parentContaner)).setWidth((String)pixelSizeCaptorWidth.capture());
        ((FlowPanel)Mockito.verify((Object)this.parentContaner)).setHeight((String)pixelSizeCaptorHeight.capture());
        Assert.assertEquals((Object)"100px", (Object)pixelSizeCaptorWidth.getValue());
        Assert.assertEquals((Object)"100px", (Object)pixelSizeCaptorHeight.getValue());
    }

    @Test
    public void testDesignerViewImplOnResize() {
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)100);
        Mockito.when((Object)this.designerViewImpl.getParent()).thenReturn((Object)this.parentWidget);
        ArgumentCaptor pixelSizeCaptorWidth = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor pixelSizeCaptorHeight = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor captorHeight = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor captorWidth = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)this.designerWidgetPresenter.getView()).thenReturn((Object)this.designerWidgetView);
        this.designerViewImpl.setDesignerWidget(this.designerWidgetPresenter);
        this.designerViewImpl.onResize();
        ((DesignerViewImpl)Mockito.verify((Object)this.designerViewImpl)).setPixelSize(((Integer)pixelSizeCaptorWidth.capture()).intValue(), ((Integer)pixelSizeCaptorHeight.capture()).intValue());
        ((DesignerViewImpl)Mockito.verify((Object)this.designerViewImpl)).setHeight((String)captorHeight.capture());
        ((DesignerViewImpl)Mockito.verify((Object)this.designerViewImpl)).setWidth((String)captorWidth.capture());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorWidth.getValue()).intValue());
        Assert.assertEquals((long)100L, (long)((Integer)pixelSizeCaptorHeight.getValue()).intValue());
        Assert.assertEquals((Object)"95px", (Object)captorHeight.getValue());
        Assert.assertEquals((Object)"100px", (Object)captorWidth.getValue());
        ((DesignerWidgetView)Mockito.verify((Object)this.designerWidgetView)).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }
}

