/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.QueryResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class QueryCommand
implements GenericCommand<QueryResults> {
    private static final long serialVersionUID = 510L;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(required=true)
    private String name;
    @XmlElement
    private List<Object> arguments;

    public QueryCommand() {
    }

    public QueryCommand(String outIdentifier, String name, Object ... arguments) {
        this.outIdentifier = outIdentifier;
        this.name = name;
        this.arguments = arguments != null ? Arrays.asList(arguments) : Collections.EMPTY_LIST;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getArguments() {
        if (this.arguments == null) {
            this.arguments = Collections.emptyList();
        }
        return this.arguments;
    }

    public void setArguments(List<Object> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            this.arguments = Collections.emptyList();
        }
        this.arguments = arguments;
    }

    @Override
    public QueryResults execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        QueryResults results = null;
        if (this.arguments == null || this.arguments.isEmpty()) {
            this.arguments = Collections.emptyList();
        }
        results = ksession.getQueryResults(this.name, this.arguments.toArray());
        if (this.outIdentifier != null) {
            ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getResults().put(this.outIdentifier, results);
        }
        return results;
    }
}

