/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.drools.FactException;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.core.util.ObjectHashMap;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class TruthMaintenanceSystem {
    private static final long serialVersionUID = 510L;
    private AbstractWorkingMemory workingMemory;
    private ObjectHashMap justifiedMap;
    private ObjectHashMap assertMap;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(AbstractWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.justifiedMap = new ObjectHashMap();
        this.assertMap = new ObjectHashMap();
        this.assertMap.setComparator(EqualityKeyComparator.getInstance());
    }

    public ObjectHashMap getJustifiedMap() {
        return this.justifiedMap;
    }

    public ObjectHashMap getAssertMap() {
        return this.assertMap;
    }

    public Object put(EqualityKey key) {
        return this.assertMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.assertMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.assertMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.assertMap.remove(key);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            this.removeLogicalDependency(activation, node, context);
        }
    }

    public void removeLogicalDependency(Activation activation, LogicalDependency node, PropagationContext context) {
        InternalFactHandle handle = (InternalFactHandle)node.getFactHandle();
        Set set = (Set)this.justifiedMap.get(handle.getId());
        if (set != null) {
            set.remove(node);
            LogicalRetractCallback action = new LogicalRetractCallback(this, node, set, handle, context, activation);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public void removeLogicalDependencies(InternalFactHandle handle) throws FactException {
        Set set = (Set)this.justifiedMap.remove(handle.getId());
        if (set != null && !set.isEmpty()) {
            for (LogicalDependency node : set) {
                node.getJustifier().getLogicalDependencies().remove(node);
            }
        }
    }

    public void addLogicalDependency(InternalFactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        LogicalDependency node = new LogicalDependency(activation, handle);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        HashSet<LogicalDependency> set = (HashSet<LogicalDependency>)this.justifiedMap.get(handle.getId());
        if (set == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            set = new HashSet<LogicalDependency>();
            this.justifiedMap.put(handle.getId(), set);
        }
        set.add(node);
    }

    public void clear() {
        this.justifiedMap.clear();
        this.assertMap.clear();
    }

    public static class LogicalRetractCallback
    implements WorkingMemoryAction {
        private TruthMaintenanceSystem tms;
        private LogicalDependency node;
        private Set set;
        private InternalFactHandle handle;
        private PropagationContext context;
        private Activation activation;

        public LogicalRetractCallback() {
        }

        public LogicalRetractCallback(TruthMaintenanceSystem tms, LogicalDependency node, Set set, InternalFactHandle handle, PropagationContext context, Activation activation) {
            this.tms = tms;
            this.node = node;
            this.set = set;
            this.handle = handle;
            this.context = context;
        }

        public LogicalRetractCallback(MarshallerReaderContext context) throws IOException {
            this.tms = context.wm.getTruthMaintenanceSystem();
            this.handle = context.handles.get(context.readInt());
            this.context = context.propagationContexts.get(context.readLong());
            this.activation = (Activation)context.terminalTupleMap.get(context.readInt()).getObject();
            this.set = (Set)this.tms.getJustifiedMap().get(this.handle.getId());
            for (LogicalDependency node : this.set) {
                if (node.getJustifier() != this.activation) continue;
                this.node = node;
                break;
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(4);
            context.writeInt(this.handle.getId());
            context.writeLong(this.context.getPropagationNumber());
            context.writeInt(context.terminalTupleMap.get(this.activation.getTuple()));
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tms = (TruthMaintenanceSystem)in.readObject();
            this.node = (LogicalDependency)in.readObject();
            this.set = (Set)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.activation = (Activation)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tms);
            out.writeObject(this.node);
            out.writeObject(this.set);
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.activation);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.set.isEmpty()) {
                this.tms.getJustifiedMap().remove(this.handle.getId());
                workingMemory.retract(this.handle, false, true, this.context.getRuleOrigin(), this.activation);
            }
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

