/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.management.DivertControl;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.Divert;
import org.hornetq.core.server.cluster.DivertConfiguration;

public class DivertControlImpl
extends AbstractControl
implements DivertControl {
    private final Divert divert;
    private final DivertConfiguration configuration;

    public DivertControlImpl(Divert divert, StorageManager storageManager, DivertConfiguration configuration) throws Exception {
        super(DivertControl.class, storageManager);
        this.divert = divert;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        this.clearIO();
        try {
            String string = this.configuration.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getForwardingAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getForwardingAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRoutingName() {
        this.clearIO();
        try {
            String string = this.divert.getRoutingName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransformerClassName() {
        this.clearIO();
        try {
            String string = this.configuration.getTransformerClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueName() {
        this.clearIO();
        try {
            String string = this.divert.getUniqueName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExclusive() {
        this.clearIO();
        try {
            boolean bl = this.divert.isExclusive();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(DivertControl.class);
    }
}

