/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.paging.PageTransactionInfo;

public class PageTransactionInfoImpl
implements PageTransactionInfo {
    private long transactionID;
    private volatile long recordID;
    private volatile CountDownLatch countDownCompleted;
    private volatile boolean committed;
    private volatile boolean rolledback;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);

    public PageTransactionInfoImpl(long transactionID) {
        this.transactionID = transactionID;
        this.countDownCompleted = new CountDownLatch(1);
    }

    public PageTransactionInfoImpl() {
    }

    public long getRecordID() {
        return this.recordID;
    }

    public void setRecordID(long recordID) {
        this.recordID = recordID;
    }

    public long getTransactionID() {
        return this.transactionID;
    }

    public int increment() {
        return this.numberOfMessages.incrementAndGet();
    }

    public int decrement() {
        int value = this.numberOfMessages.decrementAndGet();
        if (value < 0) {
            throw new IllegalStateException("Internal error Negative value on Paging transactions!");
        }
        return value;
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages.get();
    }

    public synchronized void decode(HornetQBuffer buffer) {
        this.transactionID = buffer.readLong();
        this.numberOfMessages.set(buffer.readInt());
        this.countDownCompleted = null;
        this.committed = true;
    }

    public synchronized void encode(HornetQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeInt(this.numberOfMessages.get());
    }

    public synchronized int getEncodeSize() {
        return 12;
    }

    public void commit() {
        this.committed = true;
        this.countDownCompleted.countDown();
    }

    public boolean waitCompletion(int timeoutMilliseconds) throws InterruptedException {
        if (this.countDownCompleted == null) {
            return true;
        }
        return this.countDownCompleted.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean isCommit() {
        return this.committed;
    }

    public boolean isRollback() {
        return this.rolledback;
    }

    public void rollback() {
        this.rolledback = true;
        this.committed = false;
        this.countDownCompleted.countDown();
    }

    public void markIncomplete() {
        this.committed = false;
        this.rolledback = false;
        this.countDownCompleted = new CountDownLatch(1);
    }
}

