/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsImpl
implements Bindings {
    private static final Logger log = Logger.getLogger(BindingsImpl.class);
    private final ConcurrentMap<SimpleString, List<Binding>> routingNameBindingMap = new ConcurrentHashMap<SimpleString, List<Binding>>();
    private final Map<SimpleString, Integer> routingNamePositions = new ConcurrentHashMap<SimpleString, Integer>();
    private final Map<Long, Binding> bindingsMap = new ConcurrentHashMap<Long, Binding>();
    private final List<Binding> exclusiveBindings = new CopyOnWriteArrayList<Binding>();
    private volatile boolean routeWhenNoConsumers;
    private final GroupingHandler groupingHandler;

    public BindingsImpl(GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
    }

    @Override
    public void setRouteWhenNoConsumers(boolean routeWhenNoConsumers) {
        this.routeWhenNoConsumers = routeWhenNoConsumers;
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindingsMap.values();
    }

    @Override
    public void addBinding(Binding binding) {
        if (binding.isExclusive()) {
            this.exclusiveBindings.add(binding);
        } else {
            List oldBindings;
            SimpleString routingName = binding.getRoutingName();
            List<Binding> bindings = (CopyOnWriteArrayList<Binding>)this.routingNameBindingMap.get(routingName);
            if (bindings == null && (oldBindings = (List)this.routingNameBindingMap.putIfAbsent(routingName, bindings = new CopyOnWriteArrayList<Binding>())) != null) {
                bindings = oldBindings;
            }
            bindings.add(binding);
        }
        this.bindingsMap.put(binding.getID(), binding);
    }

    @Override
    public void removeBinding(Binding binding) {
        if (binding.isExclusive()) {
            this.exclusiveBindings.remove(binding);
        } else {
            SimpleString routingName = binding.getRoutingName();
            List bindings = (List)this.routingNameBindingMap.get(routingName);
            if (bindings != null) {
                bindings.remove(binding);
                if (bindings.isEmpty()) {
                    this.routingNameBindingMap.remove(routingName);
                }
            }
        }
        this.bindingsMap.remove(binding.getID());
    }

    @Override
    public boolean redistribute(ServerMessage message, Queue originatingQueue, RoutingContext context) throws Exception {
        if (this.routeWhenNoConsumers) {
            return false;
        }
        SimpleString routingName = originatingQueue.getName();
        List bindings = (List)this.routingNameBindingMap.get(routingName);
        if (bindings == null) {
            return false;
        }
        Integer ipos = this.routingNamePositions.get(routingName);
        int pos = ipos != null ? ipos : 0;
        int length = bindings.size();
        int startPos = pos;
        Binding theBinding = null;
        while (true) {
            Binding binding;
            try {
                binding = (Binding)bindings.get(pos);
            }
            catch (IndexOutOfBoundsException e) {
                if (!bindings.isEmpty()) {
                    pos = 0;
                    startPos = 0;
                    length = bindings.size();
                    continue;
                }
                break;
            }
            pos = this.incrementPos(pos, length);
            Filter filter = binding.getFilter();
            boolean highPrior = binding.isHighAcceptPriority(message);
            if (highPrior && binding.getBindable() != originatingQueue && (filter == null || filter.match(message))) {
                theBinding = binding;
                break;
            }
            if (pos == startPos) break;
        }
        this.routingNamePositions.put(routingName, pos);
        if (theBinding != null) {
            theBinding.route(message, context);
            return true;
        }
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        boolean routed = false;
        if (!this.exclusiveBindings.isEmpty()) {
            for (Binding binding : this.exclusiveBindings) {
                if (binding.getFilter() != null && !binding.getFilter().match(message)) continue;
                binding.getBindable().route(message, context);
                routed = true;
            }
        }
        if (!routed) {
            if (message.containsProperty(MessageImpl.HDR_FROM_CLUSTER)) {
                this.routeFromCluster(message, context);
            } else if (this.groupingHandler != null && message.containsProperty(Message.HDR_GROUP_ID)) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler);
            } else {
                for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
                    Binding theBinding;
                    SimpleString routingName = (SimpleString)entry.getKey();
                    List bindings = (List)entry.getValue();
                    if (bindings == null || (theBinding = this.getNextBinding(message, routingName, bindings)) == null) continue;
                    theBinding.route(message, context);
                }
            }
        }
    }

    private Binding getNextBinding(ServerMessage message, SimpleString routingName, List<Binding> bindings) {
        Binding theBinding;
        int pos;
        block10: {
            Integer ipos = this.routingNamePositions.get(routingName);
            pos = ipos != null ? ipos : 0;
            int length = bindings.size();
            int startPos = pos;
            theBinding = null;
            int lastLowPriorityBinding = -1;
            while (true) {
                Binding binding;
                try {
                    binding = bindings.get(pos);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        startPos = 0;
                        length = bindings.size();
                        continue;
                    }
                    break block10;
                }
                Filter filter = binding.getFilter();
                if (filter == null || filter.match(message)) {
                    if (length == 1 || this.routeWhenNoConsumers || binding.isHighAcceptPriority(message)) {
                        theBinding = binding;
                        pos = this.incrementPos(pos, length);
                        break block10;
                    }
                    if (lastLowPriorityBinding == -1) {
                        lastLowPriorityBinding = pos;
                    }
                }
                if ((pos = this.incrementPos(pos, length)) != startPos) continue;
                if (lastLowPriorityBinding == -1) break block10;
                try {
                    theBinding = bindings.get(pos);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        lastLowPriorityBinding = -1;
                        continue;
                    }
                    break block10;
                }
                break;
            }
            pos = lastLowPriorityBinding;
            pos = this.incrementPos(pos, length);
        }
        this.routingNamePositions.put(routingName, pos);
        return theBinding;
    }

    private void routeUsingStrictOrdering(ServerMessage message, RoutingContext context, GroupingHandler groupingGroupingHandler) throws Exception {
        SimpleString groupId = message.getSimpleStringProperty(Message.HDR_GROUP_ID);
        for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
            SimpleString routingName = (SimpleString)entry.getKey();
            List bindings = (List)entry.getValue();
            if (bindings == null) continue;
            SimpleString fullID = groupId.concat(".").concat(routingName);
            Response resp = groupingGroupingHandler.getProposal(fullID);
            if (resp == null) {
                Binding theBinding = this.getNextBinding(message, routingName, bindings);
                resp = groupingGroupingHandler.propose(new Proposal(fullID, theBinding.getClusterName()));
                if (resp.getAlternativeClusterName() != null) {
                    theBinding = null;
                    for (Binding binding : bindings) {
                        if (!binding.getClusterName().equals(resp.getAlternativeClusterName())) continue;
                        theBinding = binding;
                        break;
                    }
                }
                if (theBinding != null) {
                    theBinding.route(message, context);
                    continue;
                }
                throw new HornetQException(100, "queue " + resp.getChosenClusterName() + " has been removed cannot deliver message, queues should not be removed when grouping is used");
            }
            Binding chosen = null;
            for (Binding binding : bindings) {
                if (!binding.getClusterName().equals(resp.getChosenClusterName())) continue;
                chosen = binding;
                break;
            }
            if (chosen != null) {
                chosen.route(message, context);
                continue;
            }
            throw new HornetQException(100, "queue " + resp.getChosenClusterName() + " has been removed cannot deliver message, queues should not be removed when grouping is used");
        }
    }

    private void routeFromCluster(ServerMessage message, RoutingContext context) throws Exception {
        byte[] ids = (byte[])message.removeProperty(MessageImpl.HDR_ROUTE_TO_IDS);
        ByteBuffer buff = ByteBuffer.wrap(ids);
        while (buff.hasRemaining()) {
            long bindingID = buff.getLong();
            Binding binding = this.bindingsMap.get(bindingID);
            if (binding == null) continue;
            binding.route(message, context);
        }
    }

    private final int incrementPos(int pos, int length) {
        if (++pos == length) {
            pos = 0;
        }
        return pos;
    }
}

