/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class ReplicationDeleteTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationDeleteTXMessage() {
        super((byte)94);
    }

    public ReplicationDeleteTXMessage(byte journalID, long txId, long id, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.id = id;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }
}

