/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;
import org.hornetq.core.remoting.impl.wireformat.XidCodecSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionXAGetInDoubtXidsResponseMessage
extends PacketImpl {
    private List<Xid> xids;

    public SessionXAGetInDoubtXidsResponseMessage(List<Xid> xids) {
        super((byte)62);
        this.xids = xids;
    }

    public SessionXAGetInDoubtXidsResponseMessage() {
        super((byte)62);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public List<Xid> getXids() {
        return this.xids;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.xids.size());
        for (Xid xid : this.xids) {
            XidCodecSupport.encodeXid(xid, buffer);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        int len = buffer.readInt();
        this.xids = new ArrayList<Xid>(len);
        for (int i = 0; i < len; ++i) {
            Xid xid = XidCodecSupport.decodeXid(buffer);
            this.xids.add(xid);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SessionXAGetInDoubtXidsResponseMessage)) {
            return false;
        }
        SessionXAGetInDoubtXidsResponseMessage r = (SessionXAGetInDoubtXidsResponseMessage)other;
        if (super.equals(other)) {
            if (this.xids.size() == r.xids.size()) {
                for (int i = 0; i < this.xids.size(); ++i) {
                    if (this.xids.get(i).equals(r.xids.get(i))) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

