/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.RollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionExpiredMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.impl.ServerSessionPacketHandler;

public interface ServerSession {
    public String getName();

    public long getID();

    public String getUsername();

    public String getPassword();

    public int getMinLargeMessageSize();

    public Object getConnectionID();

    public void removeConsumer(ServerConsumer var1) throws Exception;

    public void close() throws Exception;

    public void handleAcknowledge(SessionAcknowledgeMessage var1);

    public void handleExpired(SessionExpiredMessage var1);

    public void handleRollback(RollbackMessage var1);

    public void handleCommit(Packet var1);

    public void handleXACommit(SessionXACommitMessage var1);

    public void handleXAEnd(SessionXAEndMessage var1);

    public void handleXAForget(SessionXAForgetMessage var1);

    public void handleXAJoin(SessionXAJoinMessage var1);

    public void handleXAPrepare(SessionXAPrepareMessage var1);

    public void handleXAResume(SessionXAResumeMessage var1);

    public void handleXARollback(SessionXARollbackMessage var1);

    public void handleXAStart(SessionXAStartMessage var1);

    public void handleXASuspend(Packet var1);

    public void handleGetInDoubtXids(Packet var1);

    public void handleGetXATimeout(Packet var1);

    public void handleSetXATimeout(SessionXASetTimeoutMessage var1);

    public void handleStart(Packet var1);

    public void handleStop(Packet var1);

    public void handleCreateQueue(CreateQueueMessage var1);

    public void handleDeleteQueue(SessionDeleteQueueMessage var1);

    public void handleCreateConsumer(SessionCreateConsumerMessage var1);

    public void handleExecuteQueueQuery(SessionQueueQueryMessage var1);

    public void handleExecuteBindingQuery(SessionBindingQueryMessage var1);

    public void handleCloseConsumer(SessionConsumerCloseMessage var1);

    public void handleReceiveConsumerCredits(SessionConsumerFlowCreditMessage var1);

    public void handleSendContinuations(SessionSendContinuationMessage var1);

    public void handleSend(SessionSendMessage var1);

    public void handleSendLargeMessage(SessionSendLargeMessage var1);

    public void handleForceConsumerDelivery(SessionForceConsumerDelivery var1);

    public void handleRequestProducerCredits(SessionRequestProducerCreditsMessage var1) throws Exception;

    public void handleClose(Packet var1);

    public int transferConnection(RemotingConnection var1, int var2);

    public Channel getChannel();

    public ServerSessionPacketHandler getHandler();

    public void setHandler(ServerSessionPacketHandler var1);
}

